/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.common.expression;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.common.expression.AnyValueExpression;
import org.apache.drill.common.expression.BooleanOperator;
import org.apache.drill.common.expression.CastExpression;
import org.apache.drill.common.expression.ConvertExpression;
import org.apache.drill.common.expression.ExpressionPosition;
import org.apache.drill.common.expression.FunctionCall;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableMap;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;

public class FunctionCallFactory {
    private static final Map<String, String> OP_TO_FUNC_NAME = ImmutableMap.builder().put((Object)"+", (Object)"add").put((Object)"-", (Object)"subtract").put((Object)"/", (Object)"divide").put((Object)"*", (Object)"multiply").put((Object)"%", (Object)"modulo").put((Object)"^", (Object)"xor").put((Object)"||", (Object)"concatOperator").put((Object)"or", (Object)"booleanOr").put((Object)"and", (Object)"booleanAnd").put((Object)">", (Object)"greater_than").put((Object)"<", (Object)"less_than").put((Object)"==", (Object)"equal").put((Object)"=", (Object)"equal").put((Object)"!=", (Object)"not_equal").put((Object)"<>", (Object)"not_equal").put((Object)">=", (Object)"greater_than_or_equal_to").put((Object)"<=", (Object)"less_than_or_equal_to").put((Object)"is null", (Object)"isnull").put((Object)"is not null", (Object)"isnotnull").put((Object)"is true", (Object)"istrue").put((Object)"is not true", (Object)"isnottrue").put((Object)"is false", (Object)"isfalse").put((Object)"is not false", (Object)"isnotfalse").put((Object)"similar to", (Object)"similar_to").put((Object)"!", (Object)"not").put((Object)"u-", (Object)"negative").build();

    public static String convertToDrillFunctionName(String op) {
        return OP_TO_FUNC_NAME.getOrDefault(op, op);
    }

    public static boolean isBooleanOperator(String funcName) {
        String drillFuncName = FunctionCallFactory.convertToDrillFunctionName(funcName);
        return drillFuncName.equals("booleanAnd") || drillFuncName.equals("booleanOr");
    }

    public static LogicalExpression createCast(TypeProtos.MajorType type, ExpressionPosition ep, LogicalExpression expr) {
        return new CastExpression(expr, type, ep);
    }

    public static LogicalExpression createConvert(String function, String conversionType, LogicalExpression expr, ExpressionPosition ep) {
        return new ConvertExpression(function, conversionType, expr, ep);
    }

    public static LogicalExpression createAnyValue(ExpressionPosition ep, LogicalExpression expr) {
        return new AnyValueExpression(expr, ep);
    }

    public static LogicalExpression createAnyValue(String functionName, List<LogicalExpression> args) {
        return FunctionCallFactory.createExpression(functionName, args);
    }

    public static LogicalExpression createExpression(String functionName, List<LogicalExpression> args) {
        return FunctionCallFactory.createExpression(functionName, ExpressionPosition.UNKNOWN, args);
    }

    public static LogicalExpression createExpression(String functionName, ExpressionPosition ep, List<LogicalExpression> args) {
        String name = FunctionCallFactory.convertToDrillFunctionName(functionName);
        if (FunctionCallFactory.isBooleanOperator(name)) {
            return new BooleanOperator(name, args, ep);
        }
        return new FunctionCall(name, args, ep);
    }

    public static LogicalExpression createExpression(String functionName, ExpressionPosition ep, LogicalExpression ... e) {
        return FunctionCallFactory.createExpression(functionName, ep, Lists.newArrayList((Object[])e));
    }

    public static LogicalExpression createBooleanOperator(String functionName, List<LogicalExpression> args) {
        return FunctionCallFactory.createBooleanOperator(functionName, ExpressionPosition.UNKNOWN, args);
    }

    public static LogicalExpression createBooleanOperator(String functionName, ExpressionPosition ep, List<LogicalExpression> args) {
        return new BooleanOperator(FunctionCallFactory.convertToDrillFunctionName(functionName), args, ep);
    }

    public static LogicalExpression createByOp(List<LogicalExpression> args, ExpressionPosition ep, List<String> opTypes) {
        if (args.size() == 1) {
            return args.get(0);
        }
        if (args.size() - 1 != opTypes.size()) {
            throw new DrillRuntimeException("Must receive one more expression then the provided number of operators.");
        }
        LogicalExpression first = args.get(0);
        for (int i = 0; i < opTypes.size(); ++i) {
            ArrayList<LogicalExpression> l2 = new ArrayList<LogicalExpression>();
            l2.add(first);
            l2.add(args.get(i + 1));
            first = FunctionCallFactory.createExpression(opTypes.get(i), ep, l2);
        }
        return first;
    }
}

