/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.collect.Iterators;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.Pair;
import org.apache.iceberg.util.StructLikeSet;

public class PartitionSet
implements Set<Pair<Integer, StructLike>> {
    private final Map<Integer, Types.StructType> partitionTypeById;
    private final Map<Integer, Set<StructLike>> partitionSetById;

    public static PartitionSet create(Map<Integer, PartitionSpec> specsById) {
        return new PartitionSet(specsById);
    }

    private PartitionSet(Map<Integer, PartitionSpec> specsById) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        specsById.forEach((? super K specId, ? super V spec) -> builder.put(specId, (Object)spec.partitionType()));
        this.partitionTypeById = builder.build();
        this.partitionSetById = Maps.newHashMap();
    }

    @Override
    public int size() {
        return this.partitionSetById.values().stream().mapToInt(Set::size).sum();
    }

    @Override
    public boolean isEmpty() {
        return this.partitionSetById.values().stream().allMatch(Set::isEmpty);
    }

    @Override
    public boolean contains(Object o) {
        if (o instanceof Pair) {
            Object first = ((Pair)o).first();
            Object second = ((Pair)o).second();
            if (first instanceof Integer && second instanceof StructLike) {
                return this.contains((Integer)first, (StructLike)second);
            }
        }
        return false;
    }

    public boolean contains(int specId, StructLike struct) {
        Set<StructLike> partitionSet = this.partitionSetById.get(specId);
        if (partitionSet != null) {
            return partitionSet.contains(struct);
        }
        return false;
    }

    @Override
    public boolean add(Pair<Integer, StructLike> pair) {
        Preconditions.checkArgument((pair.first() != null ? 1 : 0) != 0, (Object)"Cannot track partition with null spec id");
        return this.add(pair.first(), pair.second());
    }

    public boolean add(int specId, StructLike struct) {
        Set partitionSet = this.partitionSetById.computeIfAbsent(specId, id -> StructLikeSet.create(this.partitionTypeById.get(id)));
        return partitionSet.add(struct);
    }

    @Override
    public boolean remove(Object o) {
        if (o instanceof Pair) {
            Object first = ((Pair)o).first();
            Object second = ((Pair)o).second();
            if (first instanceof Integer && second instanceof StructLike) {
                return this.remove((Integer)first, (StructLike)second);
            }
        }
        return false;
    }

    public boolean remove(int specId, StructLike struct) {
        Set<StructLike> partitionSet = this.partitionSetById.get(specId);
        if (partitionSet != null) {
            return partitionSet.remove(struct);
        }
        return false;
    }

    @Override
    public Iterator<Pair<Integer, StructLike>> iterator() {
        Iterable setsAsPairs = Iterables.transform(this.partitionSetById.entrySet(), idAndSet -> Iterables.transform((Iterable)((Iterable)idAndSet.getValue()), struct -> Pair.of((Integer)idAndSet.getKey(), struct)));
        return Iterables.concat((Iterable)setsAsPairs).iterator();
    }

    @Override
    public Object[] toArray() {
        return Iterators.toArray(this.iterator(), Pair.class);
    }

    @Override
    public <T> T[] toArray(T[] destArray) {
        int size = this.size();
        if (destArray.length < size) {
            return this.toArray();
        }
        Iterator<Pair<Integer, StructLike>> iter = this.iterator();
        int ind = 0;
        while (iter.hasNext()) {
            destArray[ind] = iter.next();
            ++ind;
        }
        if (destArray.length > size) {
            destArray[size] = null;
        }
        return destArray;
    }

    @Override
    public boolean containsAll(Collection<?> objects) {
        if (objects != null) {
            return Iterables.all(objects, this::contains);
        }
        return false;
    }

    @Override
    public boolean addAll(Collection<? extends Pair<Integer, StructLike>> pairs) {
        boolean changed = false;
        if (pairs != null) {
            for (Pair<Integer, StructLike> pair : pairs) {
                changed |= this.add(pair);
            }
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException("retainAll is not supported");
    }

    @Override
    public boolean removeAll(Collection<?> objects) {
        boolean changed = false;
        if (objects != null) {
            for (Object object : objects) {
                changed |= this.remove(object);
            }
        }
        return changed;
    }

    @Override
    public void clear() {
        this.partitionSetById.clear();
    }
}

