/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.deletes;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.FileMetadata;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.deletes.PositionDelete;
import org.apache.iceberg.encryption.EncryptionKeyMetadata;
import org.apache.iceberg.io.FileAppender;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.util.CharSequenceSet;

public class PositionDeleteWriter<T>
implements Closeable {
    private final FileAppender<StructLike> appender;
    private final FileFormat format;
    private final String location;
    private final PartitionSpec spec;
    private final StructLike partition;
    private final ByteBuffer keyMetadata;
    private final PositionDelete<T> delete;
    private final CharSequenceSet pathSet;
    private DeleteFile deleteFile = null;

    public PositionDeleteWriter(FileAppender<StructLike> appender, FileFormat format, String location, PartitionSpec spec, StructLike partition, EncryptionKeyMetadata keyMetadata) {
        this.appender = appender;
        this.format = format;
        this.location = location;
        this.spec = spec;
        this.partition = partition;
        this.keyMetadata = keyMetadata != null ? keyMetadata.buffer() : null;
        this.delete = PositionDelete.create();
        this.pathSet = CharSequenceSet.empty();
    }

    public void delete(CharSequence path, long pos) {
        this.delete(path, pos, null);
    }

    public void delete(CharSequence path, long pos, T row) {
        this.pathSet.add(path);
        this.appender.add(this.delete.set(path, pos, row));
    }

    @Override
    public void close() throws IOException {
        if (this.deleteFile == null) {
            this.appender.close();
            this.deleteFile = FileMetadata.deleteFileBuilder(this.spec).ofPositionDeletes().withFormat(this.format).withPath(this.location).withPartition(this.partition).withEncryptionKeyMetadata(this.keyMetadata).withFileSizeInBytes(this.appender.length()).withMetrics(this.appender.metrics()).build();
        }
    }

    public CharSequenceSet referencedDataFiles() {
        return this.pathSet;
    }

    public DeleteFile toDeleteFile() {
        Preconditions.checkState((this.deleteFile != null ? 1 : 0) != 0, (Object)"Cannot create delete file from unclosed writer");
        return this.deleteFile;
    }
}

