/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.shaded.esri.core.geometry;

import com.datastax.oss.driver.shaded.esri.core.geometry.Envelope2D;
import com.datastax.oss.driver.shaded.esri.core.geometry.Geometry;
import com.datastax.oss.driver.shaded.esri.core.geometry.GeometryException;
import com.datastax.oss.driver.shaded.esri.core.geometry.MultiPathImpl;
import com.datastax.oss.driver.shaded.esri.core.geometry.MultiPointImpl;
import com.datastax.oss.driver.shaded.esri.core.geometry.MultiVertexGeometryImpl;
import com.datastax.oss.driver.shaded.esri.core.geometry.Point2D;
import com.datastax.oss.driver.shaded.esri.core.geometry.RasterizedGeometry2D;
import com.datastax.oss.driver.shaded.esri.core.geometry.Segment;
import com.datastax.oss.driver.shaded.esri.core.geometry.SegmentIteratorImpl;
import com.datastax.oss.driver.shaded.esri.core.geometry.SimpleRasterizer;
import com.datastax.oss.driver.shaded.esri.core.geometry.Transformation2D;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

final class RasterizedGeometry2DImpl
extends RasterizedGeometry2D {
    int[] m_bitmap;
    int m_scanLineSize;
    int m_width;
    double m_dx;
    double m_dy;
    double m_x0;
    double m_y0;
    double m_toleranceXY;
    double m_stroke_half_widthX_pix;
    double m_stroke_half_widthY_pix;
    double m_stroke_half_width;
    Envelope2D m_geomEnv;
    Transformation2D m_transform;
    int m_dbgTestCount;
    SimpleRasterizer m_rasterizer;
    ScanCallbackImpl m_callback;

    void fillMultiPath(SimpleRasterizer rasterizer, Transformation2D trans, MultiPathImpl polygon, boolean isWinding) {
        SegmentIteratorImpl segIter = polygon.querySegmentIterator();
        Point2D p1 = new Point2D();
        Point2D p2 = new Point2D();
        while (segIter.nextPath()) {
            while (segIter.hasNextSegment()) {
                Segment seg = segIter.nextSegment();
                if (seg.getType() != Geometry.Type.Line) {
                    throw GeometryException.GeometryInternalError();
                }
                trans.transform(seg.getStartXY(), p1);
                trans.transform(seg.getEndXY(), p2);
                this.m_rasterizer.addEdge(p1.x, p1.y, p2.x, p2.y);
            }
        }
        this.m_rasterizer.renderEdges(isWinding ? 1 : 0);
    }

    void fillPoints(SimpleRasterizer rasterizer, MultiPointImpl geom, double stroke_half_width) {
        throw GeometryException.GeometryInternalError();
    }

    void fillConvexPolygon(SimpleRasterizer rasterizer, Point2D[] fan, int len) {
        int n = len;
        for (int i = 1; i < n; ++i) {
            rasterizer.addEdge(fan[i - 1].x, fan[i - 1].y, fan[i].x, fan[i].y);
        }
        rasterizer.addEdge(fan[len - 1].x, fan[len - 1].y, fan[0].x, fan[0].y);
        this.m_rasterizer.renderEdges(0);
    }

    void fillEnvelope(SimpleRasterizer rasterizer, Envelope2D envIn) {
        rasterizer.fillEnvelope(envIn);
    }

    void strokeDrawPolyPath(SimpleRasterizer rasterizer, MultiPathImpl polyPath, double tol) {
        Point2D[] fan = new Point2D[4];
        for (int i = 0; i < fan.length; ++i) {
            fan[i] = new Point2D();
        }
        SegmentIteratorImpl segIter = polyPath.querySegmentIterator();
        double strokeHalfWidth = this.m_transform.transform(tol) + 1.5;
        double shortSegment = 0.5;
        Point2D vec = new Point2D();
        Point2D vecA = new Point2D();
        Point2D vecB = new Point2D();
        Point2D ptStart = new Point2D();
        Point2D ptEnd = new Point2D();
        Envelope2D segEnv = new Envelope2D();
        Point2D ptOld = new Point2D();
        while (segIter.nextPath()) {
            boolean hasFan = false;
            boolean first = true;
            ptOld.setCoords(0.0, 0.0);
            while (segIter.hasNextSegment()) {
                boolean bShort;
                Segment seg = segIter.nextSegment();
                ptStart.x = seg.getStartX();
                ptStart.y = seg.getStartY();
                ptEnd.x = seg.getEndX();
                ptEnd.y = seg.getEndY();
                segEnv.setEmpty();
                segEnv.merge(ptStart.x, ptStart.y);
                segEnv.mergeNE(ptEnd.x, ptEnd.y);
                if (!this.m_geomEnv.isIntersectingNE(segEnv)) {
                    if (hasFan) {
                        this.fillConvexPolygon(rasterizer, fan, 4);
                        hasFan = false;
                    }
                    first = true;
                    continue;
                }
                this.m_transform.transform(ptEnd, ptEnd);
                if (first) {
                    this.m_transform.transform(ptStart, ptStart);
                    ptOld.setCoords(ptStart);
                    first = false;
                } else {
                    ptStart.setCoords(ptOld);
                }
                vec.sub(ptEnd, ptStart);
                double len = vec.length();
                boolean bl = bShort = len < shortSegment;
                if (len == 0.0) {
                    vec.setCoords(1.0, 0.0);
                    len = 1.0;
                    continue;
                }
                if (!bShort) {
                    ptOld.setCoords(ptEnd);
                }
                vec.scale(strokeHalfWidth / len);
                vecA.setCoords(-vec.y, vec.x);
                vecB.setCoords(vec.y, -vec.x);
                ptStart.sub(vec);
                ptEnd.add(vec);
                fan[0].add(ptStart, vecA);
                fan[1].add(ptStart, vecB);
                fan[2].add(ptEnd, vecB);
                fan[3].add(ptEnd, vecA);
                if (!bShort) {
                    this.fillConvexPolygon(rasterizer, fan, 4);
                    continue;
                }
                hasFan = true;
            }
            if (!hasFan) continue;
            this.fillConvexPolygon(rasterizer, fan, 4);
        }
    }

    int worldToPixX(double x) {
        return (int)(x * this.m_dx + this.m_x0);
    }

    int worldToPixY(double y) {
        return (int)(y * this.m_dy + this.m_y0);
    }

    RasterizedGeometry2DImpl(Geometry geom, double toleranceXY, int rasterSizeBytes) {
        this.init((MultiVertexGeometryImpl)geom._getImpl(), toleranceXY, rasterSizeBytes);
    }

    static RasterizedGeometry2DImpl createImpl(Geometry geom, double toleranceXY, int rasterSizeBytes) {
        RasterizedGeometry2DImpl rgImpl = new RasterizedGeometry2DImpl(geom, toleranceXY, rasterSizeBytes);
        return rgImpl;
    }

    private RasterizedGeometry2DImpl(MultiVertexGeometryImpl geom, double toleranceXY, int rasterSizeBytes) {
        this.init(geom, toleranceXY, rasterSizeBytes);
    }

    static RasterizedGeometry2DImpl createImpl(MultiVertexGeometryImpl geom, double toleranceXY, int rasterSizeBytes) {
        RasterizedGeometry2DImpl rgImpl = new RasterizedGeometry2DImpl(geom, toleranceXY, rasterSizeBytes);
        return rgImpl;
    }

    void init(MultiVertexGeometryImpl geom, double toleranceXY, int rasterSizeBytes) {
        ScanCallbackImpl callback;
        this.m_width = Math.max((int)(Math.sqrt(rasterSizeBytes) * 2.0 + 0.5), 64);
        this.m_scanLineSize = (this.m_width * 2 + 31) / 32;
        this.m_geomEnv = new Envelope2D();
        this.m_toleranceXY = toleranceXY;
        int size = 0;
        int width = this.m_width;
        int scanLineSize = this.m_scanLineSize;
        while (width >= 8) {
            size += width * scanLineSize;
            scanLineSize = ((width /= 2) * 2 + 31) / 32;
        }
        this.m_bitmap = new int[size];
        for (int i = 0; i < size; ++i) {
            this.m_bitmap[i] = 0;
        }
        this.m_rasterizer = new SimpleRasterizer();
        this.m_callback = callback = new ScanCallbackImpl(this.m_bitmap, this.m_scanLineSize);
        this.m_rasterizer.setup(this.m_width, this.m_width, callback);
        geom.queryEnvelope2D(this.m_geomEnv);
        if (this.m_geomEnv.getWidth() > (double)this.m_width * this.m_geomEnv.getHeight() || this.m_geomEnv.getHeight() > this.m_geomEnv.getWidth() * (double)this.m_width) {
            // empty if block
        }
        this.m_geomEnv.inflate(toleranceXY, toleranceXY);
        Envelope2D worldEnv = new Envelope2D();
        Envelope2D pixEnv = Envelope2D.construct(1.0, 1.0, this.m_width - 2, this.m_width - 2);
        double minWidth = toleranceXY * pixEnv.getWidth();
        double minHeight = toleranceXY * pixEnv.getHeight();
        worldEnv.setCoords(this.m_geomEnv.getCenter(), Math.max(minWidth, this.m_geomEnv.getWidth()), Math.max(minHeight, this.m_geomEnv.getHeight()));
        this.m_stroke_half_widthX_pix = worldEnv.getWidth() / pixEnv.getWidth();
        this.m_stroke_half_widthY_pix = worldEnv.getHeight() / pixEnv.getHeight();
        this.m_stroke_half_width = this.m_toleranceXY;
        this.m_transform = new Transformation2D();
        this.m_transform.initializeFromRect(worldEnv, pixEnv);
        Transformation2D identityTransform = new Transformation2D();
        switch (geom.getType().value()) {
            case 550: {
                callback.setColor(this.m_rasterizer, 2);
                this.fillPoints(this.m_rasterizer, (MultiPointImpl)geom, this.m_stroke_half_width);
                break;
            }
            case 1607: {
                callback.setColor(this.m_rasterizer, 2);
                this.strokeDrawPolyPath(this.m_rasterizer, (MultiPathImpl)geom._getImpl(), this.m_stroke_half_width);
                break;
            }
            case 1736: {
                boolean isWinding = false;
                callback.setColor(this.m_rasterizer, 1);
                this.fillMultiPath(this.m_rasterizer, this.m_transform, (MultiPathImpl)geom, isWinding);
                callback.setColor(this.m_rasterizer, 2);
                this.strokeDrawPolyPath(this.m_rasterizer, (MultiPathImpl)geom._getImpl(), this.m_stroke_half_width);
            }
        }
        this.m_dx = this.m_transform.xx;
        this.m_dy = this.m_transform.yy;
        this.m_x0 = this.m_transform.xd;
        this.m_y0 = this.m_transform.yd;
        this.buildLevels();
    }

    boolean tryRenderAsSmallEnvelope_(Envelope2D env) {
        if (!env.isIntersecting(this.m_geomEnv)) {
            return true;
        }
        Envelope2D envPix = new Envelope2D();
        envPix.setCoords(env);
        this.m_transform.transform(env);
        double strokeHalfWidthPixX = this.m_stroke_half_widthX_pix;
        double strokeHalfWidthPixY = this.m_stroke_half_widthY_pix;
        if (envPix.getWidth() > 2.0 * strokeHalfWidthPixX + 1.0 || envPix.getHeight() > 2.0 * strokeHalfWidthPixY + 1.0) {
            return false;
        }
        envPix.inflate(strokeHalfWidthPixX, strokeHalfWidthPixY);
        envPix.xmax += 1.0;
        envPix.ymax += 1.0;
        this.m_callback.setColor(this.m_rasterizer, 2);
        this.fillEnvelope(this.m_rasterizer, envPix);
        return true;
    }

    void buildLevels() {
        this.m_rasterizer.flush();
        int iStart = 0;
        int iStartNext = this.m_width * this.m_scanLineSize;
        int width = this.m_width;
        int widthNext = this.m_width / 2;
        int scanLineSize = this.m_scanLineSize;
        int scanLineSizeNext = (widthNext * 2 + 31) / 32;
        while (width > 8) {
            for (int iy = 0; iy < widthNext; ++iy) {
                int iysrc1 = iy * 2;
                int iysrc2 = iy * 2 + 1;
                for (int ix = 0; ix < widthNext; ++ix) {
                    int ixsrc1 = ix * 2;
                    int ixsrc2 = ix * 2 + 1;
                    int divix1 = ixsrc1 >> 4;
                    int modix1 = (ixsrc1 & 0xF) * 2;
                    int divix2 = ixsrc2 >> 4;
                    int modix2 = (ixsrc2 & 0xF) * 2;
                    int res = this.m_bitmap[iStart + scanLineSize * iysrc1 + divix1] >> modix1 & 3;
                    res |= this.m_bitmap[iStart + scanLineSize * iysrc1 + divix2] >> modix2 & 3;
                    res |= this.m_bitmap[iStart + scanLineSize * iysrc2 + divix1] >> modix1 & 3;
                    int divixDst = ix >> 4;
                    int modixDst = (ix & 0xF) * 2;
                    int n = iStartNext + scanLineSizeNext * iy + divixDst;
                    this.m_bitmap[n] = this.m_bitmap[n] | (res |= this.m_bitmap[iStart + scanLineSize * iysrc2 + divix2] >> modix2 & 3) << modixDst;
                }
            }
            width = widthNext;
            scanLineSize = scanLineSizeNext;
            iStart = iStartNext;
            widthNext = width / 2;
            scanLineSizeNext = (widthNext * 2 + 31) / 32;
            iStartNext = iStart + scanLineSize * width;
        }
    }

    @Override
    public RasterizedGeometry2D.HitType queryPointInGeometry(double x, double y) {
        if (!this.m_geomEnv.contains(x, y)) {
            return RasterizedGeometry2D.HitType.Outside;
        }
        int ix = this.worldToPixX(x);
        int iy = this.worldToPixY(y);
        if (ix < 0 || ix >= this.m_width || iy < 0 || iy >= this.m_width) {
            return RasterizedGeometry2D.HitType.Outside;
        }
        int divix = ix >> 4;
        int modix = (ix & 0xF) * 2;
        int res = this.m_bitmap[this.m_scanLineSize * iy + divix] >> modix & 3;
        if (res == 0) {
            return RasterizedGeometry2D.HitType.Outside;
        }
        if (res == 1) {
            return RasterizedGeometry2D.HitType.Inside;
        }
        return RasterizedGeometry2D.HitType.Border;
    }

    @Override
    public RasterizedGeometry2D.HitType queryEnvelopeInGeometry(Envelope2D env) {
        if (!env.intersect(this.m_geomEnv)) {
            return RasterizedGeometry2D.HitType.Outside;
        }
        int ixmin = this.worldToPixX(env.xmin);
        int ixmax = this.worldToPixX(env.xmax);
        int iymin = this.worldToPixY(env.ymin);
        int iymax = this.worldToPixY(env.ymax);
        if (ixmin < 0) {
            ixmin = 0;
        }
        if (iymin < 0) {
            iymin = 0;
        }
        if (ixmax >= this.m_width) {
            ixmax = this.m_width - 1;
        }
        if (iymax >= this.m_width) {
            iymax = this.m_width - 1;
        }
        if (ixmin > ixmax || iymin > iymax) {
            return RasterizedGeometry2D.HitType.Outside;
        }
        int area = Math.max(ixmax - ixmin, 1) * Math.max(iymax - iymin, 1);
        int iStart = 0;
        int scanLineSize = this.m_scanLineSize;
        int width = this.m_width;
        int res = 0;
        while (true) {
            if (area < 32 || width < 16) {
                for (int iy = iymin; iy <= iymax; ++iy) {
                    for (int ix = ixmin; ix <= ixmax; ++ix) {
                        int divix = ix >> 4;
                        int modix = (ix & 0xF) * 2;
                        res = this.m_bitmap[iStart + scanLineSize * iy + divix] >> modix & 3;
                        if (res <= 1) continue;
                        return RasterizedGeometry2D.HitType.Border;
                    }
                }
                if (res == 0) {
                    return RasterizedGeometry2D.HitType.Outside;
                }
                if (res == 1) {
                    return RasterizedGeometry2D.HitType.Inside;
                }
            }
            iStart += scanLineSize * width;
            scanLineSize = ((width /= 2) * 2 + 31) / 32;
            area = Math.max((ixmax /= 2) - (ixmin /= 2), 1) * Math.max((iymax /= 2) - (iymin /= 2), 1);
        }
    }

    @Override
    public double getToleranceXY() {
        return this.m_toleranceXY;
    }

    @Override
    public int getRasterSize() {
        return this.m_width * this.m_scanLineSize;
    }

    @Override
    public boolean dbgSaveToBitmap(String fileName) {
        try {
            FileOutputStream outfile = new FileOutputStream(fileName);
            int height = this.m_width;
            int width = this.m_width;
            int sz = 54 + 4 * this.m_width * height;
            ByteBuffer byteBuffer = ByteBuffer.allocate(sz);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            byteBuffer.put((byte)66);
            byteBuffer.put((byte)77);
            byteBuffer.putInt(sz);
            short zero16 = 0;
            byteBuffer.putShort(zero16);
            byteBuffer.putShort(zero16);
            int offset = 54;
            byteBuffer.putInt(offset);
            int biSize = 40;
            int biWidth = width;
            int biHeight = -height;
            short biPlanes = 1;
            short biBitCount = 32;
            int biCompression = 0;
            int biSizeImage = 4 * width * height;
            int biXPelsPerMeter = 0;
            int biYPelsPerMeter = 0;
            int biClrUsed = 0;
            int biClrImportant = 0;
            byteBuffer.putInt(biSize);
            byteBuffer.putInt(biWidth);
            byteBuffer.putInt(biHeight);
            byteBuffer.putShort(biPlanes);
            byteBuffer.putShort(biBitCount);
            byteBuffer.putInt(biCompression);
            byteBuffer.putInt(biSizeImage);
            byteBuffer.putInt(biXPelsPerMeter);
            byteBuffer.putInt(biYPelsPerMeter);
            byteBuffer.putInt(biClrUsed);
            byteBuffer.putInt(biClrImportant);
            int[] colors = new int[]{-1, -16777216, -65536, -16711936};
            for (int y = 0; y < height; ++y) {
                int scanlineIn = y * ((width * 2 + 31) / 32);
                int scanlineOut = offset + width * y;
                for (int x = 0; x < width; ++x) {
                    int res = this.m_bitmap[scanlineIn + (x >> 4)] >> (x & 0xF) * 2 & 3;
                    byteBuffer.putInt(colors[res]);
                }
            }
            byte[] b = byteBuffer.array();
            outfile.write(b);
            outfile.close();
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }

    class ScanCallbackImpl
    implements SimpleRasterizer.ScanCallback {
        int[] m_bitmap;
        int m_scanlineWidth;
        int m_color;

        public ScanCallbackImpl(int[] bitmap, int scanlineWidth) {
            this.m_scanlineWidth = scanlineWidth;
            this.m_bitmap = bitmap;
        }

        public void setColor(SimpleRasterizer rasterizer, int color) {
            if (this.m_color != color) {
                rasterizer.flush();
            }
            this.m_color = color;
        }

        @Override
        public void drawScan(int[] scans, int scanCount3) {
            int i = 0;
            while (i < scanCount3) {
                int x0 = scans[i++];
                int x1 = scans[i++];
                int y = scans[i++];
                int scanlineStart = y * this.m_scanlineWidth;
                for (int xx = x0; xx < x1; ++xx) {
                    int n = scanlineStart + (xx >> 4);
                    this.m_bitmap[n] = this.m_bitmap[n] | this.m_color << (xx & 0xF) * 2;
                }
            }
        }
    }
}

