/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.metadata.token;

import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
class CanonicalNodeSetBuilder {
    private final Map<List<Node>, Set<Node>> canonicalSets = new HashMap<List<Node>, Set<Node>>();
    private final List<Node> elements = new ArrayList<Node>();

    CanonicalNodeSetBuilder() {
    }

    void add(Node node) {
        if (!this.elements.contains(node)) {
            this.elements.add(node);
        }
    }

    int size() {
        return this.elements.size();
    }

    Set<Node> build() {
        return this.canonicalSets.computeIfAbsent(this.elements, ImmutableSet::copyOf);
    }

    void clear() {
        this.elements.clear();
    }
}

