/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.api.core.data.geometry;

import com.datastax.dse.driver.api.core.data.geometry.Geometry;
import com.datastax.dse.driver.internal.core.data.geometry.DefaultGeometry;
import com.datastax.dse.driver.internal.core.data.geometry.DefaultPoint;
import com.datastax.oss.driver.shaded.esri.core.geometry.ogc.OGCPoint;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.nio.ByteBuffer;

public interface Point
extends Geometry {
    @NonNull
    public static Point fromWellKnownText(@NonNull String source) {
        return new DefaultPoint(DefaultGeometry.fromOgcWellKnownText(source, OGCPoint.class));
    }

    @NonNull
    public static Point fromWellKnownBinary(@NonNull ByteBuffer source) {
        return new DefaultPoint(DefaultGeometry.fromOgcWellKnownBinary(source, OGCPoint.class));
    }

    @NonNull
    public static Point fromGeoJson(@NonNull String source) {
        return new DefaultPoint(DefaultGeometry.fromOgcGeoJson(source, OGCPoint.class));
    }

    @NonNull
    public static Point fromCoordinates(double x, double y) {
        return new DefaultPoint(x, y);
    }

    public double X();

    public double Y();
}

