/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.hive.writers.primitive;

import io.netty.buffer.DrillBuf;
import org.apache.drill.exec.store.hive.writers.primitive.AbstractSingleValueWriter;
import org.apache.drill.exec.vector.complex.writer.VarCharWriter;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.StringObjectInspector;
import org.apache.hadoop.io.Text;

public class HiveStringWriter
extends AbstractSingleValueWriter<StringObjectInspector, VarCharWriter> {
    private DrillBuf drillBuf;

    public HiveStringWriter(StringObjectInspector inspector, VarCharWriter writer, DrillBuf drillBuf) {
        super(inspector, writer);
        this.drillBuf = drillBuf;
    }

    @Override
    public void write(Object value) {
        Text textValue = ((StringObjectInspector)this.inspector).getPrimitiveWritableObject(value);
        byte[] bytes = textValue.getBytes();
        this.drillBuf = this.drillBuf.reallocIfNeeded(bytes.length);
        this.drillBuf.setBytes(0, bytes);
        ((VarCharWriter)this.writer).writeVarChar(0, textValue.getLength(), this.drillBuf);
    }
}

