/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.hive.writers.primitive;

import java.sql.Date;
import org.apache.drill.exec.store.hive.writers.primitive.AbstractSingleValueWriter;
import org.apache.drill.exec.vector.complex.writer.DateWriter;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class HiveDateWriter
extends AbstractSingleValueWriter<PrimitiveObjectInspector, DateWriter> {
    public HiveDateWriter(PrimitiveObjectInspector inspector, DateWriter writer) {
        super(inspector, writer);
    }

    @Override
    public void write(Object value) {
        String dateString = PrimitiveObjectInspectorUtils.getString((Object)value, (PrimitiveObjectInspector)((PrimitiveObjectInspector)this.inspector));
        long dateMillis = new DateTime(Date.valueOf(dateString).getTime()).withZoneRetainFields(DateTimeZone.UTC).getMillis();
        ((DateWriter)this.writer).writeDate(dateMillis);
    }
}

