/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.hive.writers.primitive;

import io.netty.buffer.DrillBuf;
import org.apache.drill.exec.store.hive.writers.primitive.AbstractSingleValueWriter;
import org.apache.drill.exec.vector.complex.writer.VarCharWriter;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.HiveCharObjectInspector;
import org.apache.hadoop.io.Text;

public class HiveCharWriter
extends AbstractSingleValueWriter<HiveCharObjectInspector, VarCharWriter> {
    private DrillBuf drillBuf;

    public HiveCharWriter(HiveCharObjectInspector inspector, VarCharWriter writer, DrillBuf drillBuf) {
        super(inspector, writer);
        this.drillBuf = drillBuf;
    }

    @Override
    public void write(Object value) {
        Text textValue = ((HiveCharObjectInspector)this.inspector).getPrimitiveWritableObject(value).getStrippedValue();
        byte[] bytes = textValue.getBytes();
        this.drillBuf = this.drillBuf.reallocIfNeeded(bytes.length);
        this.drillBuf.setBytes(0, bytes);
        ((VarCharWriter)this.writer).writeVarChar(0, textValue.getLength(), this.drillBuf);
    }
}

