/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.hive.schema;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.Table;
import org.apache.drill.common.AutoCloseables;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.exec.store.AbstractSchema;
import org.apache.drill.exec.store.AbstractSchemaFactory;
import org.apache.drill.exec.store.SchemaConfig;
import org.apache.drill.exec.store.hive.HiveReadEntry;
import org.apache.drill.exec.store.hive.HiveStoragePlugin;
import org.apache.drill.exec.store.hive.client.DrillHiveMetaStoreClient;
import org.apache.drill.exec.store.hive.client.DrillHiveMetaStoreClientFactory;
import org.apache.drill.exec.store.hive.schema.DrillHiveTable;
import org.apache.drill.exec.store.hive.schema.DrillHiveViewTable;
import org.apache.drill.exec.store.hive.schema.HiveDatabaseSchema;
import org.apache.drill.exec.util.ImpersonationUtil;
import org.apache.drill.shaded.guava.com.google.common.cache.CacheBuilder;
import org.apache.drill.shaded.guava.com.google.common.cache.CacheLoader;
import org.apache.drill.shaded.guava.com.google.common.cache.LoadingCache;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveSchemaFactory
extends AbstractSchemaFactory {
    private static final Logger logger = LoggerFactory.getLogger(HiveSchemaFactory.class);
    private final DrillHiveMetaStoreClient processUserMetastoreClient;
    private final LoadingCache<String, DrillHiveMetaStoreClient> metaStoreClientLoadingCache;
    private final HiveStoragePlugin plugin;
    private final boolean isDrillImpersonationEnabled;
    private final boolean isHS2DoAsSet;

    public HiveSchemaFactory(HiveStoragePlugin plugin, String name, final HiveConf hiveConf) throws ExecutionSetupException {
        super(name);
        this.plugin = plugin;
        this.isHS2DoAsSet = hiveConf.getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_ENABLE_DOAS);
        this.isDrillImpersonationEnabled = plugin.getContext().getConfig().getBoolean("drill.exec.impersonation.enabled");
        try {
            this.processUserMetastoreClient = DrillHiveMetaStoreClientFactory.createCloseableClientWithCaching(hiveConf);
        }
        catch (MetaException e) {
            throw new ExecutionSetupException("Failure setting up Hive metastore client.", (Throwable)e);
        }
        this.metaStoreClientLoadingCache = CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).maximumSize(5L).removalListener(notification -> {
            DrillHiveMetaStoreClient client = (DrillHiveMetaStoreClient)((Object)((Object)notification.getValue()));
            client.close();
        }).build((CacheLoader)new CacheLoader<String, DrillHiveMetaStoreClient>(){

            public DrillHiveMetaStoreClient load(String userName) {
                return DrillHiveMetaStoreClientFactory.createClientWithAuthz(HiveSchemaFactory.this.processUserMetastoreClient, hiveConf, userName);
            }
        });
    }

    public void close() {
        AutoCloseable[] autoCloseableArray = new AutoCloseable[2];
        autoCloseableArray[0] = this.processUserMetastoreClient;
        autoCloseableArray[1] = () -> this.metaStoreClientLoadingCache.invalidateAll();
        AutoCloseables.closeSilently((AutoCloseable[])autoCloseableArray);
    }

    public void registerSchemas(SchemaConfig schemaConfig, SchemaPlus parent) throws IOException {
        DrillHiveMetaStoreClient mClientForSchemaTree = this.processUserMetastoreClient;
        if (this.isDrillImpersonationEnabled) {
            try {
                mClientForSchemaTree = (DrillHiveMetaStoreClient)((Object)this.metaStoreClientLoadingCache.get((Object)schemaConfig.getUserName()));
            }
            catch (ExecutionException e) {
                throw new IOException("Failure setting up Hive metastore client.", e);
            }
        }
        HiveSchema schema = new HiveSchema(schemaConfig, mClientForSchemaTree, this.getName());
        SchemaPlus hPlus = parent.add(this.getName(), (Schema)schema);
        schema.setHolder(hPlus);
    }

    class HiveSchema
    extends AbstractSchema {
        private final SchemaConfig schemaConfig;
        private final DrillHiveMetaStoreClient mClient;
        private HiveDatabaseSchema defaultSchema;

        HiveSchema(SchemaConfig schemaConfig, DrillHiveMetaStoreClient mClient, String name) {
            super(Collections.emptyList(), name);
            this.schemaConfig = schemaConfig;
            this.mClient = mClient;
            this.getSubSchema("default");
        }

        public AbstractSchema getSubSchema(String name) {
            try {
                List<String> dbs = this.mClient.getDatabases(this.schemaConfig.getIgnoreAuthErrors());
                if (!dbs.contains(name)) {
                    logger.debug("Database '{}' doesn't exists in Hive storage '{}'", (Object)name, (Object)this.getName());
                    return null;
                }
                HiveDatabaseSchema schema = this.getSubSchemaKnownExists(name);
                if ("default".equals(name)) {
                    this.defaultSchema = schema;
                }
                return schema;
            }
            catch (TException e) {
                throw new DrillRuntimeException((Throwable)e);
            }
        }

        private HiveDatabaseSchema getSubSchemaKnownExists(String name) {
            return new HiveDatabaseSchema(this, name, this.mClient, this.schemaConfig);
        }

        void setHolder(SchemaPlus plusOfThis) {
            for (String s : this.getSubSchemaNames()) {
                plusOfThis.add(s, (Schema)this.getSubSchemaKnownExists(s));
            }
        }

        public boolean showInInformationSchema() {
            return false;
        }

        public Set<String> getSubSchemaNames() {
            try {
                List<String> dbs = this.mClient.getDatabases(this.schemaConfig.getIgnoreAuthErrors());
                return new HashSet<String>(dbs);
            }
            catch (TException e) {
                logger.warn("Failure while getting Hive database list.", (Throwable)e);
                return super.getSubSchemaNames();
            }
        }

        public Table getTable(String name) {
            if (this.defaultSchema == null) {
                return super.getTable(name);
            }
            return this.defaultSchema.getTable(name);
        }

        public Set<String> getTableNames() {
            if (this.defaultSchema == null) {
                return super.getTableNames();
            }
            return this.defaultSchema.getTableNames();
        }

        public boolean areTableNamesCaseSensitive() {
            return false;
        }

        Table getDrillTable(String dbName, String t) {
            HiveReadEntry entry = this.getSelectionBaseOnName(dbName, t);
            if (entry == null) {
                return null;
            }
            String schemaUser = this.schemaConfig.getUserName();
            return Schema.TableType.VIEW == entry.getJdbcTableType() ? new DrillHiveViewTable(entry, this.schemaPath, this.schemaConfig, this.getUser(schemaUser, entry.getTable().getOwner())) : new DrillHiveTable(this.getName(), HiveSchemaFactory.this.plugin, this.getUser(schemaUser, ImpersonationUtil.getProcessUserName()), entry);
        }

        public String getUser(String impersonated, String notImpersonated) {
            return this.needToImpersonateReadingData() ? impersonated : notImpersonated;
        }

        HiveReadEntry getSelectionBaseOnName(String dbName, String t) {
            if (dbName == null) {
                dbName = "default";
            }
            try {
                return this.mClient.getHiveReadEntry(dbName, t, this.schemaConfig.getIgnoreAuthErrors());
            }
            catch (TException e) {
                logger.warn("Exception occurred while trying to read table. {}.{}", new Object[]{dbName, t, e.getCause()});
                return null;
            }
        }

        public AbstractSchema getDefaultSchema() {
            return this.defaultSchema;
        }

        public String getTypeName() {
            return "hive";
        }

        public boolean needToImpersonateReadingData() {
            return HiveSchemaFactory.this.isDrillImpersonationEnabled && HiveSchemaFactory.this.isHS2DoAsSet;
        }
    }
}

