/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.hive.schema;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.sql.type.SqlTypeFactoryImpl;
import org.apache.drill.exec.dotdrill.View;
import org.apache.drill.exec.planner.logical.DrillViewTable;
import org.apache.drill.exec.planner.sql.SchemaUtilities;
import org.apache.drill.exec.planner.sql.conversion.DrillViewExpander;
import org.apache.drill.exec.planner.types.DrillRelDataTypeSystem;
import org.apache.drill.exec.planner.types.HiveToRelDataTypeConverter;
import org.apache.drill.exec.store.SchemaConfig;
import org.apache.drill.exec.store.hive.HiveReadEntry;
import org.apache.drill.exec.store.hive.HiveTableWithColumnCache;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableList;
import org.apache.hadoop.hive.metastore.api.FieldSchema;

public class DrillHiveViewTable
extends DrillViewTable {
    private static final HiveToRelDataTypeConverter DATA_TYPE_CONVERTER = new HiveToRelDataTypeConverter((RelDataTypeFactory)new SqlTypeFactoryImpl(DrillRelDataTypeSystem.DRILL_REL_DATATYPE_SYSTEM));

    public DrillHiveViewTable(HiveReadEntry entry, List<String> schemaPath, SchemaConfig schemaConfig, String user) {
        super(DrillHiveViewTable.createView(schemaPath, entry.getTable()), user, schemaConfig.getViewExpansionContext());
    }

    protected RelNode expandViewForImpersonatedUser(DrillViewExpander context, List<String> workspaceSchemaPath, SchemaPlus tokenSchemaTree) {
        SchemaPlus drillHiveSchema = SchemaUtilities.findSchema((SchemaPlus)tokenSchemaTree, workspaceSchemaPath);
        workspaceSchemaPath = ImmutableList.of();
        return super.expandViewForImpersonatedUser(context, (List)workspaceSchemaPath, drillHiveSchema);
    }

    private static View createView(List<String> schemaPath, HiveTableWithColumnCache hiveView) {
        List<View.Field> viewFields = DrillHiveViewTable.getViewFieldTypes(hiveView);
        String viewName = hiveView.getTableName();
        String viewSql = hiveView.getViewExpandedText();
        return new View(viewName, viewSql, viewFields, schemaPath);
    }

    private static List<View.Field> getViewFieldTypes(HiveTableWithColumnCache hiveTable) {
        return Stream.of(hiveTable.getColumnListsCache().getTableSchemaColumns(), hiveTable.getPartitionKeys()).flatMap(Collection::stream).map(hiveField -> new View.Field(hiveField.getName(), DATA_TYPE_CONVERTER.convertToNullableRelDataType((FieldSchema)hiveField))).collect(Collectors.toList());
    }
}

