/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.hive.readers.inspectors;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import org.apache.drill.exec.store.hive.readers.inspectors.AbstractRecordsInspector;
import org.apache.hadoop.mapred.RecordReader;

public class SkipFooterRecordsInspector
extends AbstractRecordsInspector {
    private final int footerCount;
    private Queue<Object> footerBuffer;
    private final List<Object> valueHolders;
    private long readRecordsCount;

    public SkipFooterRecordsInspector(RecordReader<Object, Object> reader, int footerCount) {
        this.footerCount = footerCount;
        this.footerBuffer = new LinkedList<Object>();
        this.valueHolders = this.initializeValueHolders(reader, footerCount);
    }

    @Override
    public Object getValueHolder() {
        int availableHolderIndex = (int)this.readRecordsCount % this.valueHolders.size();
        return this.valueHolders.get(availableHolderIndex);
    }

    @Override
    public Object getNextValue() {
        this.footerBuffer.add(this.getValueHolder());
        ++this.readRecordsCount;
        if (this.footerBuffer.size() <= this.footerCount) {
            return null;
        }
        return this.footerBuffer.poll();
    }

    private List<Object> initializeValueHolders(RecordReader<Object, Object> reader, int footerCount) {
        ArrayList<Object> valueHolder = new ArrayList<Object>(footerCount + 1);
        for (int i = 0; i <= footerCount; ++i) {
            valueHolder.add(reader.createValue());
        }
        return valueHolder;
    }
}

