/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.hive.client;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.calcite.schema.Schema;
import org.apache.drill.exec.store.hive.HiveReadEntry;
import org.apache.drill.exec.store.hive.client.DatabaseNameCacheLoader;
import org.apache.drill.exec.store.hive.client.DrillHiveMetaStoreClient;
import org.apache.drill.exec.store.hive.client.TableEntryCacheLoader;
import org.apache.drill.exec.store.hive.client.TableName;
import org.apache.drill.exec.store.hive.client.TableNameCacheLoader;
import org.apache.drill.shaded.guava.com.google.common.base.Strings;
import org.apache.drill.shaded.guava.com.google.common.cache.CacheBuilder;
import org.apache.drill.shaded.guava.com.google.common.cache.CacheLoader;
import org.apache.drill.shaded.guava.com.google.common.cache.LoadingCache;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class HiveMetadataCache {
    private static final Logger logger = LoggerFactory.getLogger(HiveMetadataCache.class);
    private static final String HIVE_METASTORE_CACHE_TTL = "hive.metastore.cache-ttl-seconds";
    private static final String HIVE_METASTORE_CACHE_EXPIRE = "hive.metastore.cache-expire-after";
    private static final String HIVE_METASTORE_CACHE_EXPIRE_AFTER_ACCESS = "access";
    private final LoadingCache<String, List<String>> dbNamesCache;
    private final LoadingCache<String, Map<String, Schema.TableType>> tableNamesCache;
    private final LoadingCache<TableName, HiveReadEntry> tableEntryCache;

    HiveMetadataCache(DrillHiveMetaStoreClient client, HiveConf hiveConf) {
        CacheBuilder cacheBuilder = this.isExpireAfterWrite(hiveConf) ? CacheBuilder.newBuilder().expireAfterWrite((long)this.getHmsCacheTTL(hiveConf), TimeUnit.SECONDS) : CacheBuilder.newBuilder().expireAfterAccess((long)this.getHmsCacheTTL(hiveConf), TimeUnit.SECONDS);
        this.dbNamesCache = cacheBuilder.build((CacheLoader)new DatabaseNameCacheLoader(client));
        this.tableNamesCache = cacheBuilder.build((CacheLoader)new TableNameCacheLoader(client));
        this.tableEntryCache = cacheBuilder.build((CacheLoader)new TableEntryCacheLoader(client));
    }

    List<String> getDbNames() throws TException {
        try {
            return (List)this.dbNamesCache.get((Object)"databases");
        }
        catch (ExecutionException e) {
            throw new TException((Throwable)e);
        }
    }

    Map<String, Schema.TableType> getTableNamesAndTypes(String dbName) throws TException {
        try {
            return (Map)this.tableNamesCache.get((Object)dbName);
        }
        catch (ExecutionException e) {
            throw new TException((Throwable)e);
        }
    }

    HiveReadEntry getHiveReadEntry(String dbName, String tableName) throws TException {
        try {
            return (HiveReadEntry)this.tableEntryCache.get((Object)TableName.of(dbName, tableName));
        }
        catch (ExecutionException e) {
            throw new TException((Throwable)e);
        }
    }

    private boolean isExpireAfterWrite(HiveConf hiveConf) {
        boolean expireAfterWrite = true;
        String expiry = hiveConf.get(HIVE_METASTORE_CACHE_EXPIRE);
        if (HIVE_METASTORE_CACHE_EXPIRE_AFTER_ACCESS.equalsIgnoreCase(expiry)) {
            expireAfterWrite = false;
            logger.warn("Hive metastore cache expire policy is set to {}", (Object)"expireAfterAccess");
        }
        return expireAfterWrite;
    }

    private int getHmsCacheTTL(HiveConf hiveConf) {
        int hmsCacheTTL = 60;
        String ttl = hiveConf.get(HIVE_METASTORE_CACHE_TTL);
        if (!Strings.isNullOrEmpty((String)ttl)) {
            hmsCacheTTL = Integer.valueOf(ttl);
            logger.warn("Hive metastore cache ttl is set to {} seconds.", (Object)hmsCacheTTL);
        }
        return hmsCacheTTL;
    }
}

