/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.hive.client;

import java.util.List;
import java.util.Map;
import org.apache.calcite.schema.Schema;
import org.apache.drill.exec.store.hive.HiveReadEntry;
import org.apache.drill.exec.store.hive.client.HiveMetadataCache;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.thrift.TException;

public class DrillHiveMetaStoreClient
extends HiveMetaStoreClient {
    private final HiveMetadataCache hiveMetadataCache;

    DrillHiveMetaStoreClient(HiveConf hiveConf) throws MetaException {
        super((Configuration)hiveConf);
        this.hiveMetadataCache = new HiveMetadataCache(this, hiveConf);
    }

    public List<String> getDatabases(boolean ignoreAuthzErrors) throws TException {
        return this.hiveMetadataCache.getDbNames();
    }

    public HiveReadEntry getHiveReadEntry(String dbName, String tableName, boolean ignoreAuthzErrors) throws TException {
        return this.hiveMetadataCache.getHiveReadEntry(dbName, tableName);
    }

    public Map<String, Schema.TableType> getTableNamesAndTypes(String dbName, boolean ignoreAuthzErrors) throws TException {
        return this.hiveMetadataCache.getTableNamesAndTypes(dbName);
    }

    public synchronized String getDelegationToken(String owner, String renewerKerberosPrincipalName) throws TException {
        return super.getDelegationToken(owner, renewerKerberosPrincipalName);
    }
}

