/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.hive;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.DrillBuf;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.expr.holders.Decimal18Holder;
import org.apache.drill.exec.expr.holders.Decimal28SparseHolder;
import org.apache.drill.exec.expr.holders.Decimal38SparseHolder;
import org.apache.drill.exec.expr.holders.Decimal9Holder;
import org.apache.drill.exec.physical.impl.scan.v3.schema.SchemaUtils;
import org.apache.drill.exec.planner.logical.DrillScanRel;
import org.apache.drill.exec.planner.types.HiveToRelDataTypeConverter;
import org.apache.drill.exec.record.metadata.ColumnMetadata;
import org.apache.drill.exec.server.options.OptionSet;
import org.apache.drill.exec.store.hive.HivePartition;
import org.apache.drill.exec.store.hive.HiveReadEntry;
import org.apache.drill.exec.store.hive.HiveScan;
import org.apache.drill.exec.store.hive.HiveTableWithColumnCache;
import org.apache.drill.exec.store.hive.HiveTableWrapper;
import org.apache.drill.exec.util.DecimalUtility;
import org.apache.drill.exec.vector.NullableBigIntVector;
import org.apache.drill.exec.vector.NullableBitVector;
import org.apache.drill.exec.vector.NullableDateVector;
import org.apache.drill.exec.vector.NullableDecimal18Vector;
import org.apache.drill.exec.vector.NullableDecimal28SparseVector;
import org.apache.drill.exec.vector.NullableDecimal38SparseVector;
import org.apache.drill.exec.vector.NullableDecimal9Vector;
import org.apache.drill.exec.vector.NullableFloat4Vector;
import org.apache.drill.exec.vector.NullableFloat8Vector;
import org.apache.drill.exec.vector.NullableIntVector;
import org.apache.drill.exec.vector.NullableTimeStampVector;
import org.apache.drill.exec.vector.NullableVarBinaryVector;
import org.apache.drill.exec.vector.NullableVarCharVector;
import org.apache.drill.exec.vector.NullableVarDecimalVector;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.exec.work.ExecErrorConstants;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.apache.drill.shaded.guava.com.google.common.base.Strings;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.HiveStorageHandler;
import org.apache.hadoop.hive.ql.metadata.HiveUtils;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.BaseCharTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.HiveDecimalUtils;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveUtilities {
    private static final Logger logger = LoggerFactory.getLogger(HiveUtilities.class);

    public static Object convertPartitionType(TypeInfo typeInfo, String value, String defaultPartitionValue) {
        if (typeInfo.getCategory() != ObjectInspector.Category.PRIMITIVE) {
            throw new DrillRuntimeException("Non-Primitive types are not allowed as partition column type in Hive, but received one: " + typeInfo.getCategory());
        }
        if (defaultPartitionValue.equals(value)) {
            return null;
        }
        PrimitiveObjectInspector.PrimitiveCategory pCat = ((PrimitiveTypeInfo)typeInfo).getPrimitiveCategory();
        try {
            switch (pCat) {
                case BINARY: {
                    return value.getBytes(StandardCharsets.UTF_8);
                }
                case BOOLEAN: {
                    return Boolean.parseBoolean(value);
                }
                case DECIMAL: {
                    DecimalTypeInfo decimalTypeInfo = (DecimalTypeInfo)typeInfo;
                    return HiveDecimalUtils.enforcePrecisionScale((HiveDecimal)HiveDecimal.create((String)value), (DecimalTypeInfo)decimalTypeInfo);
                }
                case DOUBLE: {
                    return Double.parseDouble(value);
                }
                case FLOAT: {
                    return Float.valueOf(Float.parseFloat(value));
                }
                case BYTE: 
                case SHORT: 
                case INT: {
                    return Integer.parseInt(value);
                }
                case LONG: {
                    return Long.parseLong(value);
                }
                case STRING: 
                case VARCHAR: {
                    return value.getBytes(StandardCharsets.UTF_8);
                }
                case CHAR: {
                    return value.trim().getBytes(StandardCharsets.UTF_8);
                }
                case TIMESTAMP: {
                    return Timestamp.valueOf(value);
                }
                case DATE: {
                    return Date.valueOf(value);
                }
            }
        }
        catch (Exception e) {
            logger.trace("Failed to interpret '{}' value from partition value string '{}'", (Object)pCat, (Object)value);
            return null;
        }
        HiveUtilities.throwUnsupportedHiveDataTypeError(pCat.toString());
        return null;
    }

    public static void populateVector(ValueVector vector, DrillBuf managedBuffer, Object val, int start, int end) {
        TypeProtos.MinorType type = vector.getField().getType().getMinorType();
        switch (type) {
            case VARBINARY: {
                NullableVarBinaryVector v = (NullableVarBinaryVector)vector;
                byte[] value = (byte[])val;
                for (int i = start; i < end; ++i) {
                    v.getMutator().setSafe(i, value, 0, value.length);
                }
                break;
            }
            case BIT: {
                NullableBitVector v = (NullableBitVector)vector;
                Boolean value = (Boolean)val;
                for (int i = start; i < end; ++i) {
                    v.getMutator().set(i, value != false ? 1 : 0);
                }
                break;
            }
            case FLOAT8: {
                NullableFloat8Vector v = (NullableFloat8Vector)vector;
                double value = (Double)val;
                for (int i = start; i < end; ++i) {
                    v.getMutator().setSafe(i, value);
                }
                break;
            }
            case FLOAT4: {
                NullableFloat4Vector v = (NullableFloat4Vector)vector;
                float value = ((Float)val).floatValue();
                for (int i = start; i < end; ++i) {
                    v.getMutator().setSafe(i, value);
                }
                break;
            }
            case TINYINT: 
            case SMALLINT: 
            case INT: {
                NullableIntVector v = (NullableIntVector)vector;
                int value = (Integer)val;
                for (int i = start; i < end; ++i) {
                    v.getMutator().setSafe(i, value);
                }
                break;
            }
            case BIGINT: {
                NullableBigIntVector v = (NullableBigIntVector)vector;
                long value = (Long)val;
                for (int i = start; i < end; ++i) {
                    v.getMutator().setSafe(i, value);
                }
                break;
            }
            case VARCHAR: {
                NullableVarCharVector v = (NullableVarCharVector)vector;
                byte[] value = (byte[])val;
                for (int i = start; i < end; ++i) {
                    v.getMutator().setSafe(i, value, 0, value.length);
                }
                break;
            }
            case TIMESTAMP: {
                NullableTimeStampVector v = (NullableTimeStampVector)vector;
                DateTime ts = new DateTime(((Timestamp)val).getTime()).withZoneRetainFields(DateTimeZone.UTC);
                long value = ts.getMillis();
                for (int i = start; i < end; ++i) {
                    v.getMutator().setSafe(i, value);
                }
                break;
            }
            case DATE: {
                NullableDateVector v = (NullableDateVector)vector;
                DateTime date = new DateTime(((Date)val).getTime()).withZoneRetainFields(DateTimeZone.UTC);
                long value = date.getMillis();
                for (int i = start; i < end; ++i) {
                    v.getMutator().setSafe(i, value);
                }
                break;
            }
            case DECIMAL9: {
                BigDecimal value = ((HiveDecimal)val).bigDecimalValue();
                NullableDecimal9Vector v = (NullableDecimal9Vector)vector;
                Decimal9Holder holder = new Decimal9Holder();
                holder.scale = v.getField().getScale();
                holder.precision = v.getField().getPrecision();
                holder.value = DecimalUtility.getDecimal9FromBigDecimal((BigDecimal)value, (int)holder.scale);
                for (int i = start; i < end; ++i) {
                    v.getMutator().setSafe(i, holder);
                }
                break;
            }
            case DECIMAL18: {
                BigDecimal value = ((HiveDecimal)val).bigDecimalValue();
                NullableDecimal18Vector v = (NullableDecimal18Vector)vector;
                Decimal18Holder holder = new Decimal18Holder();
                holder.scale = v.getField().getScale();
                holder.precision = v.getField().getPrecision();
                holder.value = DecimalUtility.getDecimal18FromBigDecimal((BigDecimal)value, (int)holder.scale);
                for (int i = start; i < end; ++i) {
                    v.getMutator().setSafe(i, holder);
                }
                break;
            }
            case DECIMAL28SPARSE: {
                int needSpace = 20;
                Preconditions.checkArgument((managedBuffer.capacity() > 20 ? 1 : 0) != 0, (Object)String.format("Not sufficient space in given managed buffer. Need %d bytes, buffer has %d bytes", 20, managedBuffer.capacity()));
                BigDecimal value = ((HiveDecimal)val).bigDecimalValue();
                NullableDecimal28SparseVector v = (NullableDecimal28SparseVector)vector;
                Decimal28SparseHolder holder = new Decimal28SparseHolder();
                holder.scale = v.getField().getScale();
                holder.precision = v.getField().getPrecision();
                holder.buffer = managedBuffer;
                holder.start = 0;
                DecimalUtility.getSparseFromBigDecimal((BigDecimal)value, (ByteBuf)holder.buffer, (int)0, (int)holder.scale, (int)5);
                for (int i = start; i < end; ++i) {
                    v.getMutator().setSafe(i, holder);
                }
                break;
            }
            case DECIMAL38SPARSE: {
                int needSpace = 24;
                Preconditions.checkArgument((managedBuffer.capacity() > 24 ? 1 : 0) != 0, (Object)String.format("Not sufficient space in given managed buffer. Need %d bytes, buffer has %d bytes", 24, managedBuffer.capacity()));
                BigDecimal value = ((HiveDecimal)val).bigDecimalValue();
                NullableDecimal38SparseVector v = (NullableDecimal38SparseVector)vector;
                Decimal38SparseHolder holder = new Decimal38SparseHolder();
                holder.scale = v.getField().getScale();
                holder.precision = v.getField().getPrecision();
                holder.buffer = managedBuffer;
                holder.start = 0;
                DecimalUtility.getSparseFromBigDecimal((BigDecimal)value, (ByteBuf)holder.buffer, (int)0, (int)holder.scale, (int)6);
                for (int i = start; i < end; ++i) {
                    v.getMutator().setSafe(i, holder);
                }
                break;
            }
            case VARDECIMAL: {
                BigDecimal value = ((HiveDecimal)val).bigDecimalValue().setScale(vector.getField().getScale(), RoundingMode.HALF_UP);
                NullableVarDecimalVector v = (NullableVarDecimalVector)vector;
                for (int i = start; i < end; ++i) {
                    v.getMutator().setSafe(i, value);
                }
                break;
            }
        }
    }

    public static TypeProtos.MajorType getMajorTypeFromHiveTypeInfo(TypeInfo typeInfo, OptionSet options) {
        switch (typeInfo.getCategory()) {
            case PRIMITIVE: {
                PrimitiveTypeInfo primitiveTypeInfo = (PrimitiveTypeInfo)typeInfo;
                TypeProtos.MinorType minorType = HiveUtilities.getMinorTypeFromHivePrimitiveTypeInfo(primitiveTypeInfo, options);
                TypeProtos.MajorType.Builder typeBuilder = TypeProtos.MajorType.newBuilder().setMinorType(minorType).setMode(TypeProtos.DataMode.OPTIONAL);
                switch (primitiveTypeInfo.getPrimitiveCategory()) {
                    case VARCHAR: 
                    case CHAR: {
                        BaseCharTypeInfo baseCharTypeInfo = (BaseCharTypeInfo)primitiveTypeInfo;
                        typeBuilder.setPrecision(baseCharTypeInfo.getLength());
                        break;
                    }
                    case DECIMAL: {
                        DecimalTypeInfo decimalTypeInfo = (DecimalTypeInfo)primitiveTypeInfo;
                        typeBuilder.setPrecision(decimalTypeInfo.getPrecision()).setScale(decimalTypeInfo.getScale());
                        break;
                    }
                }
                return typeBuilder.build();
            }
        }
        HiveUtilities.throwUnsupportedHiveDataTypeError(typeInfo.getCategory().toString());
        return null;
    }

    public static TypeProtos.MinorType getMinorTypeFromHivePrimitiveTypeInfo(PrimitiveTypeInfo primitiveTypeInfo, OptionSet options) {
        switch (primitiveTypeInfo.getPrimitiveCategory()) {
            case BINARY: {
                return TypeProtos.MinorType.VARBINARY;
            }
            case BOOLEAN: {
                return TypeProtos.MinorType.BIT;
            }
            case DECIMAL: {
                if (!options.getOption((String)"planner.enable_decimal_data_type").bool_val.booleanValue()) {
                    throw UserException.unsupportedError().message(ExecErrorConstants.DECIMAL_DISABLE_ERR_MSG, new Object[0]).build(logger);
                }
                return TypeProtos.MinorType.VARDECIMAL;
            }
            case DOUBLE: {
                return TypeProtos.MinorType.FLOAT8;
            }
            case FLOAT: {
                return TypeProtos.MinorType.FLOAT4;
            }
            case BYTE: 
            case SHORT: 
            case INT: {
                return TypeProtos.MinorType.INT;
            }
            case LONG: {
                return TypeProtos.MinorType.BIGINT;
            }
            case STRING: 
            case VARCHAR: 
            case CHAR: {
                return TypeProtos.MinorType.VARCHAR;
            }
            case TIMESTAMP: {
                return TypeProtos.MinorType.TIMESTAMP;
            }
            case DATE: {
                return TypeProtos.MinorType.DATE;
            }
        }
        HiveUtilities.throwUnsupportedHiveDataTypeError(primitiveTypeInfo.getPrimitiveCategory().toString());
        return null;
    }

    public static Class<? extends InputFormat<?, ?>> getInputFormatClass(JobConf job, StorageDescriptor sd, Table table) throws Exception {
        String inputFormatName = sd.getInputFormat();
        if (Strings.isNullOrEmpty((String)inputFormatName)) {
            String storageHandlerClass = (String)table.getParameters().get("storage_handler");
            if (Strings.isNullOrEmpty((String)storageHandlerClass)) {
                throw new ExecutionSetupException("Unable to get Hive table InputFormat class. There is neither InputFormat class explicitly specified nor StorageHandler class");
            }
            HiveStorageHandler storageHandler = HiveUtils.getStorageHandler((Configuration)job, (String)storageHandlerClass);
            TableDesc tableDesc = new TableDesc();
            tableDesc.setProperties(new org.apache.hadoop.hive.ql.metadata.Table(table).getMetadata());
            storageHandler.configureInputJobProperties(tableDesc, table.getParameters());
            return storageHandler.getInputFormatClass();
        }
        return Class.forName(inputFormatName);
    }

    public static void addConfToJob(JobConf job, Properties properties) {
        for (Object obj : properties.keySet()) {
            job.set((String)obj, (String)properties.get(obj));
        }
    }

    public static Properties getPartitionMetadata(HivePartition partition, HiveTableWithColumnCache table) {
        HiveUtilities.restoreColumns(table, partition);
        try {
            Properties properties = new Partition(new org.apache.hadoop.hive.ql.metadata.Table((Table)table), (org.apache.hadoop.hive.metastore.api.Partition)partition).getMetadataFromPartitionSchema();
            table.getParameters().entrySet().stream().filter(e -> e.getKey() != null && e.getValue() != null).forEach(e -> properties.put(e.getKey(), e.getValue()));
            return properties;
        }
        catch (HiveException e2) {
            throw new DrillRuntimeException((Throwable)e2);
        }
    }

    public static void restoreColumns(HiveTableWithColumnCache table, HivePartition partition) {
        if (partition != null && partition.getSd().getCols() == null) {
            partition.getSd().setCols(table.getColumnListsCache().getColumns(partition.getColumnListIndex()));
        }
        if (table.getSd().getCols() == null) {
            table.getSd().setCols(table.getColumnListsCache().getColumns(0));
        }
    }

    public static Properties getTableMetadata(HiveTableWithColumnCache table) {
        HiveUtilities.restoreColumns(table, null);
        return new org.apache.hadoop.hive.ql.metadata.Table((Table)table).getMetadata();
    }

    public static void throwUnsupportedHiveDataTypeError(String unsupportedType) {
        StringBuilder errMsg = new StringBuilder().append("Unsupported Hive data type ").append(unsupportedType).append(". ").append(System.lineSeparator()).append("Following Hive data types are supported in Drill for querying: ").append("BOOLEAN, TINYINT, SMALLINT, INT, BIGINT, FLOAT, DOUBLE, DATE, TIMESTAMP, BINARY, DECIMAL, STRING, VARCHAR, CHAR, ARRAY.");
        throw UserException.unsupportedError().message(errMsg.toString(), new Object[0]).build(logger);
    }

    public static int retrieveIntProperty(Properties tableProperties, String propertyName, int defaultValue) {
        Object propertyObject = tableProperties.get(propertyName);
        if (propertyObject == null) {
            return defaultValue;
        }
        try {
            return Integer.valueOf(propertyObject.toString());
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException(String.format("Hive table property %s value '%s' is non-numeric", propertyName, propertyObject.toString()));
        }
    }

    public static boolean hasHeaderOrFooter(HiveTableWithColumnCache table) {
        Properties tableProperties = HiveUtilities.getTableMetadata(table);
        int skipHeader = HiveUtilities.retrieveIntProperty(tableProperties, "skip.header.line.count", -1);
        int skipFooter = HiveUtilities.retrieveIntProperty(tableProperties, "skip.footer.line.count", -1);
        return skipHeader > 0 || skipFooter > 0;
    }

    public static void verifyAndAddTransactionalProperties(JobConf job, StorageDescriptor sd) {
        if (AcidUtils.isTablePropertyTransactional((Configuration)job)) {
            HiveConf.setBoolVar((Configuration)job, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_TRANSACTIONAL_TABLE_SCAN, (boolean)true);
            if (Utilities.isSchemaEvolutionEnabled((Configuration)job, (boolean)true) && job.get("schema.evolution.columns") != null && job.get("schema.evolution.columns.types") != null) {
                return;
            }
            String colNames = job.get("columns");
            String colTypes = job.get("columns.types");
            if (colNames == null || colTypes == null) {
                colNames = sd.getCols().stream().map(FieldSchema::getName).collect(Collectors.joining(","));
                colTypes = sd.getCols().stream().map(FieldSchema::getType).collect(Collectors.joining(","));
            }
            job.set("schema.evolution.columns", colNames);
            job.set("schema.evolution.columns.types", colTypes);
        }
    }

    public static boolean nativeReadersRuleMatches(RelOptRuleCall call, Class tableInputFormatClass) {
        DrillScanRel scanRel = (DrillScanRel)call.rel(0);
        if (!(scanRel.getGroupScan() instanceof HiveScan) || ((HiveScan)scanRel.getGroupScan()).isNativeReader()) {
            return false;
        }
        HiveScan hiveScan = (HiveScan)scanRel.getGroupScan();
        HiveConf hiveConf = hiveScan.getHiveConf();
        HiveTableWithColumnCache hiveTable = hiveScan.getHiveReadEntry().getTable();
        if (HiveUtilities.isParquetTableContainsUnsupportedType(hiveTable)) {
            return false;
        }
        Class<InputFormat<?, ?>> tableInputFormat = HiveUtilities.getInputFormatFromSD(HiveUtilities.getTableMetadata(hiveTable), hiveScan.getHiveReadEntry(), hiveTable.getSd(), hiveConf);
        if (tableInputFormat == null || !tableInputFormat.equals(tableInputFormatClass)) {
            return false;
        }
        List<HiveTableWrapper.HivePartitionWrapper> partitions = hiveScan.getHiveReadEntry().getHivePartitionWrappers();
        if (partitions == null) {
            return true;
        }
        List tableSchema = hiveTable.getSd().getCols();
        for (HiveTableWrapper.HivePartitionWrapper partition : partitions) {
            StorageDescriptor partitionSD = partition.getPartition().getSd();
            Class<InputFormat<?, ?>> inputFormat = HiveUtilities.getInputFormatFromSD(HiveUtilities.getPartitionMetadata(partition.getPartition(), hiveTable), hiveScan.getHiveReadEntry(), partitionSD, hiveConf);
            if (inputFormat == null || !inputFormat.equals(tableInputFormat)) {
                return false;
            }
            if (partitionSD.getCols().equals(tableSchema)) continue;
            logger.debug("Partitions schema is different from table schema. Currently native reader conversion can't handle schema difference between partitions and table");
            return false;
        }
        return true;
    }

    private static Class<? extends InputFormat<?, ?>> getInputFormatFromSD(Properties properties, HiveReadEntry hiveReadEntry, StorageDescriptor sd, HiveConf hiveConf) {
        HiveTableWithColumnCache hiveTable = hiveReadEntry.getTable();
        try {
            String inputFormatName = sd.getInputFormat();
            if (!Strings.isNullOrEmpty((String)inputFormatName)) {
                return Class.forName(inputFormatName);
            }
            JobConf job = new JobConf((Configuration)hiveConf);
            HiveUtilities.addConfToJob(job, properties);
            return HiveUtilities.getInputFormatClass(job, sd, hiveTable);
        }
        catch (Exception e) {
            logger.warn("Failed to get InputFormat class from Hive table '{}.{}'. StorageDescriptor [{}]", new Object[]{hiveTable.getDbName(), hiveTable.getTableName(), sd.toString(), e});
            return null;
        }
    }

    private static boolean isParquetTableContainsUnsupportedType(Table hiveTable) {
        for (FieldSchema hiveField : hiveTable.getSd().getCols()) {
            ObjectInspector.Category category = TypeInfoUtils.getTypeInfoFromTypeString((String)hiveField.getType()).getCategory();
            if (category != ObjectInspector.Category.UNION) continue;
            logger.debug("Hive table contains unsupported data type: {}", (Object)category);
            return true;
        }
        return false;
    }

    public static HiveConf generateHiveConf(Map<String, String> properties) {
        logger.trace("Override HiveConf with the following properties {}", properties);
        HiveConf hiveConf = new HiveConf();
        properties.forEach((arg_0, arg_1) -> ((HiveConf)hiveConf).set(arg_0, arg_1));
        return hiveConf;
    }

    public static HiveConf generateHiveConf(HiveConf hiveConf, Map<String, String> properties) {
        Properties changedProperties = hiveConf.getChangedProperties();
        changedProperties.putAll(properties);
        HiveConf newHiveConf = new HiveConf();
        changedProperties.stringPropertyNames().forEach(name -> newHiveConf.set(name, changedProperties.getProperty((String)name)));
        return newHiveConf;
    }

    public static HiveTableWrapper.HivePartitionWrapper createPartitionWithSpecColumns(HiveTableWithColumnCache table, org.apache.hadoop.hive.metastore.api.Partition partition) {
        int listIndex = table.getColumnListsCache().addOrGet(partition.getSd().getCols());
        return new HiveTableWrapper.HivePartitionWrapper(new HivePartition(partition, listIndex));
    }

    public static ColumnMetadata getColumnMetadata(HiveToRelDataTypeConverter dataTypeConverter, FieldSchema column) {
        RelDataType relDataType = dataTypeConverter.convertToNullableRelDataType(column);
        return SchemaUtils.getColumnMetadata((String)column.getName(), (RelDataType)relDataType);
    }
}

