/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.hive;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.drill.exec.store.hive.ColumnListsCache;
import org.apache.drill.exec.store.hive.HivePartition;
import org.apache.drill.exec.store.hive.HiveTableWithColumnCache;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Order;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;

@JsonTypeName(value="table")
public class HiveTableWrapper {
    @JsonIgnore
    private HiveTableWithColumnCache table;
    @JsonProperty
    public String tableName;
    @JsonProperty
    public String dbName;
    @JsonProperty
    public String owner;
    @JsonProperty
    public int createTime;
    @JsonProperty
    public int lastAccessTime;
    @JsonProperty
    public int retention;
    @JsonProperty
    public StorageDescriptorWrapper sd;
    @JsonProperty
    public List<FieldSchemaWrapper> partitionKeys;
    @JsonProperty
    public Map<String, String> parameters;
    @JsonProperty
    public String viewOriginalText;
    @JsonProperty
    public String viewExpandedText;
    @JsonProperty
    public String tableType;
    @JsonProperty
    public ColumnsCacheWrapper columnsCache;
    @JsonIgnore
    public final Map<String, String> partitionNameTypeMap = new HashMap<String, String>();

    @JsonCreator
    public HiveTableWrapper(@JsonProperty(value="tableName") String tableName, @JsonProperty(value="dbName") String dbName, @JsonProperty(value="owner") String owner, @JsonProperty(value="createTime") int createTime, @JsonProperty(value="lastAccessTime") int lastAccessTime, @JsonProperty(value="retention") int retention, @JsonProperty(value="sd") StorageDescriptorWrapper sd, @JsonProperty(value="partitionKeys") List<FieldSchemaWrapper> partitionKeys, @JsonProperty(value="parameters") Map<String, String> parameters, @JsonProperty(value="viewOriginalText") String viewOriginalText, @JsonProperty(value="viewExpandedText") String viewExpandedText, @JsonProperty(value="tableType") String tableType, @JsonProperty(value="columnsCache") ColumnsCacheWrapper columnsCache) {
        this.tableName = tableName;
        this.dbName = dbName;
        this.owner = owner;
        this.createTime = createTime;
        this.lastAccessTime = lastAccessTime;
        this.retention = retention;
        this.sd = sd;
        this.partitionKeys = partitionKeys;
        this.parameters = parameters;
        this.viewOriginalText = viewOriginalText;
        this.viewExpandedText = viewExpandedText;
        this.tableType = tableType;
        this.columnsCache = columnsCache;
        ArrayList partitionKeysUnwrapped = Lists.newArrayList();
        for (FieldSchemaWrapper w : partitionKeys) {
            partitionKeysUnwrapped.add(w.getFieldSchema());
            this.partitionNameTypeMap.put(w.name, w.type);
        }
        StorageDescriptor sdUnwrapped = sd.getSd();
        this.table = new HiveTableWithColumnCache(tableName, dbName, owner, createTime, lastAccessTime, retention, sdUnwrapped, partitionKeysUnwrapped, parameters, viewOriginalText, viewExpandedText, tableType, columnsCache.getColumnListsCache());
    }

    public HiveTableWrapper(HiveTableWithColumnCache table) {
        if (table == null) {
            return;
        }
        this.table = table;
        this.tableName = table.getTableName();
        this.dbName = table.getDbName();
        this.owner = table.getOwner();
        this.createTime = table.getCreateTime();
        this.lastAccessTime = table.getLastAccessTime();
        this.retention = table.getRetention();
        this.sd = new StorageDescriptorWrapper(table.getSd());
        this.partitionKeys = Lists.newArrayList();
        for (FieldSchema f : table.getPartitionKeys()) {
            this.partitionKeys.add(new FieldSchemaWrapper(f));
            this.partitionNameTypeMap.put(f.getName(), f.getType());
        }
        this.parameters = table.getParameters();
        this.viewOriginalText = table.getViewOriginalText();
        this.viewExpandedText = table.getViewExpandedText();
        this.tableType = table.getTableType();
        this.columnsCache = new ColumnsCacheWrapper(table.getColumnListsCache());
    }

    @JsonIgnore
    public HiveTableWithColumnCache getTable() {
        return this.table;
    }

    @JsonIgnore
    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Table(");
        sb.append("dbName:");
        sb.append(this.dbName);
        sb.append(", ");
        sb.append("tableName:");
        sb.append(this.tableName);
        sb.append(")");
        return sb.toString();
    }

    public Map<String, String> getPartitionNameTypeMap() {
        return this.partitionNameTypeMap;
    }

    public static class StorageDescriptorWrapper {
        @JsonIgnore
        private StorageDescriptor sd;
        @JsonIgnore
        public List<FieldSchemaWrapper> columns;
        @JsonProperty
        public String location;
        @JsonProperty
        public String inputFormat;
        @JsonProperty
        public String outputFormat;
        @JsonProperty
        public boolean compressed;
        @JsonProperty
        public int numBuckets;
        @JsonProperty
        public SerDeInfoWrapper serDeInfo;
        @JsonProperty
        public List<OrderWrapper> sortCols;
        @JsonProperty
        public Map<String, String> parameters;

        @JsonCreator
        public StorageDescriptorWrapper(@JsonProperty(value="columns") List<FieldSchemaWrapper> columns, @JsonProperty(value="location") String location, @JsonProperty(value="inputFormat") String inputFormat, @JsonProperty(value="outputFormat") String outputFormat, @JsonProperty(value="compressed") boolean compressed, @JsonProperty(value="numBuckets") int numBuckets, @JsonProperty(value="serDeInfo") SerDeInfoWrapper serDeInfo, @JsonProperty(value="sortCols") List<OrderWrapper> sortCols, @JsonProperty(value="parameters") Map<String, String> parameters) {
            ArrayList sortColsUnwrapped;
            ArrayList colsUnwrapped;
            this.columns = columns;
            this.location = location;
            this.inputFormat = inputFormat;
            this.outputFormat = outputFormat;
            this.compressed = compressed;
            this.numBuckets = numBuckets;
            this.serDeInfo = serDeInfo;
            this.sortCols = sortCols;
            this.parameters = parameters;
            if (columns != null) {
                colsUnwrapped = Lists.newArrayList();
                for (FieldSchemaWrapper fieldSchema : columns) {
                    colsUnwrapped.add(fieldSchema.getFieldSchema());
                }
            } else {
                colsUnwrapped = null;
            }
            SerDeInfo serDeInfoUnwrapped = serDeInfo.getSerDeInfo();
            if (sortCols != null) {
                sortColsUnwrapped = Lists.newArrayList();
                for (OrderWrapper order : sortCols) {
                    sortColsUnwrapped.add(order.getOrder());
                }
            } else {
                sortColsUnwrapped = null;
            }
            this.sd = new StorageDescriptor((List)colsUnwrapped, location, inputFormat, outputFormat, compressed, numBuckets, serDeInfoUnwrapped, null, (List)sortColsUnwrapped, parameters);
        }

        public StorageDescriptorWrapper(StorageDescriptor storageDescriptor) {
            this.sd = storageDescriptor;
            this.location = storageDescriptor.getLocation();
            this.inputFormat = storageDescriptor.getInputFormat();
            this.outputFormat = storageDescriptor.getOutputFormat();
            this.compressed = storageDescriptor.isCompressed();
            this.numBuckets = storageDescriptor.getNumBuckets();
            this.serDeInfo = new SerDeInfoWrapper(storageDescriptor.getSerdeInfo());
            if (this.sd.getSortCols() != null) {
                this.sortCols = Lists.newArrayList();
                for (Order order : this.sd.getSortCols()) {
                    this.sortCols.add(new OrderWrapper(order));
                }
            }
            this.parameters = storageDescriptor.getParameters();
            if (this.sd.getCols() != null) {
                this.columns = Lists.newArrayList();
                for (FieldSchema fieldSchema : this.sd.getCols()) {
                    this.columns.add(new FieldSchemaWrapper(fieldSchema));
                }
            }
        }

        @JsonIgnore
        public StorageDescriptor getSd() {
            return this.sd;
        }
    }

    public static class ColumnsCacheWrapper {
        @JsonIgnore
        private final ColumnListsCache columnListsCache;
        @JsonProperty
        private final List<List<FieldSchemaWrapper>> keys;

        @JsonCreator
        public ColumnsCacheWrapper(@JsonProperty(value="keys") List<List<FieldSchemaWrapper>> keys) {
            this.keys = keys;
            this.columnListsCache = new ColumnListsCache();
            for (List<FieldSchemaWrapper> columns : keys) {
                ArrayList columnsUnwrapped = Lists.newArrayList();
                for (FieldSchemaWrapper field : columns) {
                    columnsUnwrapped.add(field.getFieldSchema());
                }
                this.columnListsCache.addOrGet(columnsUnwrapped);
            }
        }

        public ColumnsCacheWrapper(ColumnListsCache columnListsCache) {
            this.columnListsCache = columnListsCache;
            ArrayList keysWrapped = Lists.newArrayList();
            for (List<FieldSchema> columns : columnListsCache.getFields()) {
                ArrayList columnsWrapped = Lists.newArrayList();
                for (FieldSchema field : columns) {
                    columnsWrapped.add(new FieldSchemaWrapper(field));
                }
                keysWrapped.add(columnsWrapped);
            }
            this.keys = keysWrapped;
        }

        @JsonIgnore
        public ColumnListsCache getColumnListsCache() {
            return this.columnListsCache;
        }
    }

    public static class FieldSchemaWrapper {
        @JsonIgnore
        private FieldSchema fieldSchema;
        @JsonProperty
        public String name;
        @JsonProperty
        public String type;
        @JsonProperty
        public String comment;

        @JsonCreator
        public FieldSchemaWrapper(@JsonProperty(value="name") String name, @JsonProperty(value="type") String type, @JsonProperty(value="comment") String comment) {
            this.name = name;
            this.type = type;
            this.comment = comment;
            this.fieldSchema = new FieldSchema(name, type, comment);
        }

        public FieldSchemaWrapper(FieldSchema fieldSchema) {
            this.fieldSchema = fieldSchema;
            this.name = fieldSchema.getName();
            this.type = fieldSchema.getType();
            this.comment = fieldSchema.getComment();
        }

        @JsonIgnore
        public FieldSchema getFieldSchema() {
            return this.fieldSchema;
        }
    }

    public static class OrderWrapper {
        @JsonIgnore
        private Order ord;
        @JsonProperty
        public String col;
        @JsonProperty
        public int order;

        @JsonCreator
        public OrderWrapper(@JsonProperty(value="col") String col, @JsonProperty(value="order") int order) {
            this.col = col;
            this.order = order;
        }

        public OrderWrapper(Order ord) {
            this.ord = ord;
            this.col = ord.getCol();
            this.order = ord.getOrder();
        }

        @JsonIgnore
        public Order getOrder() {
            return this.ord;
        }
    }

    public static class SerDeInfoWrapper {
        @JsonIgnore
        private SerDeInfo serDeInfo;
        @JsonProperty
        public String name;
        @JsonProperty
        public String serializationLib;
        @JsonProperty
        public Map<String, String> parameters;

        @JsonCreator
        public SerDeInfoWrapper(@JsonProperty(value="name") String name, @JsonProperty(value="serializationLib") String serializationLib, @JsonProperty(value="parameters") Map<String, String> parameters) {
            this.name = name;
            this.serializationLib = serializationLib;
            this.parameters = parameters;
            this.serDeInfo = new SerDeInfo(name, serializationLib, parameters);
        }

        public SerDeInfoWrapper(SerDeInfo serDeInfo) {
            this.serDeInfo = serDeInfo;
            this.name = serDeInfo.getName();
            this.serializationLib = serDeInfo.getSerializationLib();
            this.parameters = serDeInfo.getParameters();
        }

        @JsonIgnore
        public SerDeInfo getSerDeInfo() {
            return this.serDeInfo;
        }
    }

    public static class HivePartitionWrapper {
        @JsonIgnore
        private HivePartition partition;
        @JsonProperty
        public List<String> values;
        @JsonProperty
        public String tableName;
        @JsonProperty
        public String dbName;
        @JsonProperty
        public int createTime;
        @JsonProperty
        public int lastAccessTime;
        @JsonProperty
        public StorageDescriptorWrapper sd;
        @JsonProperty
        public Map<String, String> parameters;
        @JsonProperty
        private int columnListIndex;

        @JsonCreator
        public HivePartitionWrapper(@JsonProperty(value="values") List<String> values, @JsonProperty(value="tableName") String tableName, @JsonProperty(value="dbName") String dbName, @JsonProperty(value="createTime") int createTime, @JsonProperty(value="lastAccessTime") int lastAccessTime, @JsonProperty(value="sd") StorageDescriptorWrapper sd, @JsonProperty(value="parameters") Map<String, String> parameters, @JsonProperty(value="columnListIndex") int columnListIndex) {
            this.values = values;
            this.tableName = tableName;
            this.dbName = dbName;
            this.createTime = createTime;
            this.lastAccessTime = lastAccessTime;
            this.sd = sd;
            this.parameters = parameters;
            this.columnListIndex = columnListIndex;
            StorageDescriptor sdUnwrapped = sd.getSd();
            this.partition = new HivePartition(values, tableName, dbName, createTime, lastAccessTime, sdUnwrapped, parameters, columnListIndex);
        }

        public HivePartitionWrapper(HivePartition partition) {
            if (partition == null) {
                return;
            }
            this.partition = partition;
            this.values = partition.getValues();
            this.tableName = partition.getTableName();
            this.dbName = partition.getDbName();
            this.createTime = partition.getCreateTime();
            this.lastAccessTime = partition.getLastAccessTime();
            this.sd = new StorageDescriptorWrapper(partition.getSd());
            this.parameters = partition.getParameters();
            this.columnListIndex = partition.getColumnListIndex();
        }

        @JsonIgnore
        public HivePartition getPartition() {
            return this.partition;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("Partition(");
            sb.append("values:");
            sb.append(this.values);
            sb.append(")");
            return sb.toString();
        }
    }
}

