/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl.hive;

import org.apache.drill.exec.expr.fn.impl.hive.AbstractDrillPrimitiveObjectInspector;
import org.apache.drill.exec.expr.holders.NullableTimeStampHolder;
import org.apache.drill.exec.expr.holders.TimeStampHolder;
import org.apache.hadoop.hive.common.type.Timestamp;
import org.apache.hadoop.hive.serde2.io.TimestampWritableV2;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.TimestampObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;

public class DrillTimeStampTimestampObjectInspector {

    public static class Optional
    extends AbstractDrillPrimitiveObjectInspector
    implements TimestampObjectInspector {
        public Optional() {
            super(TypeInfoFactory.timestampTypeInfo);
        }

        public Timestamp getPrimitiveJavaObject(Object o) {
            if (o == null) {
                return null;
            }
            NullableTimeStampHolder h = (NullableTimeStampHolder)o;
            return Timestamp.ofEpochMilli((long)h.value);
        }

        public TimestampWritableV2 getPrimitiveWritableObject(Object o) {
            if (o == null) {
                return null;
            }
            NullableTimeStampHolder h = (NullableTimeStampHolder)o;
            return new TimestampWritableV2(Timestamp.ofEpochMilli((long)h.value));
        }
    }

    public static class Required
    extends AbstractDrillPrimitiveObjectInspector
    implements TimestampObjectInspector {
        public Required() {
            super(TypeInfoFactory.timestampTypeInfo);
        }

        public Timestamp getPrimitiveJavaObject(Object o) {
            TimeStampHolder h = (TimeStampHolder)o;
            return Timestamp.ofEpochMilli((long)h.value);
        }

        public TimestampWritableV2 getPrimitiveWritableObject(Object o) {
            TimeStampHolder h = (TimeStampHolder)o;
            return new TimestampWritableV2(Timestamp.ofEpochMilli((long)h.value));
        }
    }
}

