/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn;

import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JCatchBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JConditional;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JStatement;
import com.sun.codemodel.JTryBlock;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import java.util.List;
import org.apache.drill.common.expression.ExpressionPosition;
import org.apache.drill.common.expression.FieldReference;
import org.apache.drill.common.expression.FunctionHolderExpression;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.expr.ClassGenerator;
import org.apache.drill.exec.expr.HiveFuncHolderExpr;
import org.apache.drill.exec.expr.TypeHelper;
import org.apache.drill.exec.expr.fn.AbstractFuncHolder;
import org.apache.drill.exec.expr.fn.impl.hive.DrillDeferredObject;
import org.apache.drill.exec.expr.fn.impl.hive.ObjectInspectorHelper;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBridge;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;

public class HiveFuncHolder
extends AbstractFuncHolder {
    private TypeProtos.MajorType[] argTypes;
    private ObjectInspector returnOI;
    private TypeProtos.MajorType returnType;
    private Class<? extends GenericUDF> genericUdfClazz;
    private boolean isGenericUDF = true;
    private Class<? extends UDF> udfClazz = null;
    private String udfName = "";
    private boolean isRandom;

    public HiveFuncHolder(Class<? extends GenericUDF> genericUdfClazz, TypeProtos.MajorType[] argTypes, ObjectInspector returnOI, TypeProtos.MajorType returnType, boolean isRandom) {
        this.genericUdfClazz = genericUdfClazz;
        this.argTypes = argTypes;
        this.returnOI = returnOI;
        this.returnType = returnType;
        this.isRandom = isRandom;
    }

    public HiveFuncHolder(String udfName, Class<? extends UDF> udfClazz, TypeProtos.MajorType[] argTypes, ObjectInspector returnOI, TypeProtos.MajorType returnType, boolean isRandom) {
        this(GenericUDFBridge.class, argTypes, returnOI, returnType, isRandom);
        this.isGenericUDF = false;
        this.udfClazz = udfClazz;
        this.udfName = udfName;
    }

    public TypeProtos.MajorType getReturnType() {
        return this.returnType;
    }

    public boolean isAggregating() {
        return false;
    }

    public boolean isRandom() {
        return this.isRandom;
    }

    public TypeProtos.MajorType getParamMajorType(int i) {
        return this.argTypes[i];
    }

    public int getParamCount() {
        return this.argTypes.length;
    }

    public JVar[] renderStart(ClassGenerator<?> g, ClassGenerator.HoldingContainer[] inputVariables, FieldReference fieldReference) {
        JVar[] workspaceJVars = new JVar[]{g.declareClassField("returnOI", g.getModel()._ref(ObjectInspector.class)), g.declareClassField("udfInstance", g.getModel()._ref(GenericUDF.class)), g.declareClassField("deferredObjects", g.getModel()._ref(DrillDeferredObject[].class)), g.declareClassField("arguments", g.getModel()._ref(DrillDeferredObject[].class)), g.declareClassField("returnValueHolder", TypeHelper.getHolderType((JCodeModel)g.getModel(), (TypeProtos.MinorType)this.returnType.getMinorType(), (TypeProtos.DataMode)TypeProtos.DataMode.OPTIONAL))};
        return workspaceJVars;
    }

    public ClassGenerator.HoldingContainer renderEnd(ClassGenerator<?> classGenerator, ClassGenerator.HoldingContainer[] inputVariables, JVar[] workspaceJVars, FunctionHolderExpression holderExpr) {
        this.generateSetup(classGenerator, workspaceJVars);
        return this.generateEval(classGenerator, inputVariables, workspaceJVars);
    }

    private JInvocation getUDFInstance(JCodeModel m) {
        if (this.isGenericUDF) {
            return JExpr._new((JClass)m.directClass(this.genericUdfClazz.getCanonicalName()));
        }
        return JExpr._new((JClass)m.directClass(GenericUDFBridge.class.getCanonicalName())).arg(JExpr.lit((String)this.udfName)).arg(JExpr.lit((boolean)false)).arg(JExpr.lit((String)this.udfClazz.getCanonicalName().toString()));
    }

    public FunctionHolderExpression getExpr(String name, List<LogicalExpression> args, ExpressionPosition pos) {
        return new HiveFuncHolderExpr(name, this, args, pos);
    }

    private void generateSetup(ClassGenerator<?> g, JVar[] workspaceJVars) {
        int i;
        JCodeModel m = g.getModel();
        JBlock sub = new JBlock(true, true);
        JVar oiArray = sub.decl(m._ref(ObjectInspector[].class), "argOIs", (JExpression)JExpr.newArray((JType)m._ref(ObjectInspector.class), (int)this.argTypes.length));
        JClass oih = m.directClass(ObjectInspectorHelper.class.getCanonicalName());
        JClass mt = m.directClass(TypeProtos.MinorType.class.getCanonicalName());
        JClass mode = m.directClass(TypeProtos.DataMode.class.getCanonicalName());
        for (i = 0; i < this.argTypes.length; ++i) {
            sub.assign((JAssignmentTarget)oiArray.component(JExpr.lit((int)i)), (JExpression)oih.staticInvoke("getDrillObjectInspector").arg((JExpression)mode.staticInvoke("valueOf").arg(JExpr.lit((int)this.argTypes[i].getMode().getNumber()))).arg((JExpression)mt.staticInvoke("valueOf").arg(JExpr.lit((int)this.argTypes[i].getMinorType().getNumber()))).arg(((PrimitiveObjectInspector)this.returnOI).getPrimitiveCategory() == PrimitiveObjectInspector.PrimitiveCategory.STRING ? JExpr.lit((boolean)true) : JExpr.lit((boolean)false)));
        }
        sub.assign((JAssignmentTarget)workspaceJVars[2], (JExpression)JExpr.newArray((JType)m._ref(DrillDeferredObject.class), (int)this.argTypes.length));
        for (i = 0; i < this.argTypes.length; ++i) {
            sub.assign((JAssignmentTarget)workspaceJVars[2].component(JExpr.lit((int)i)), (JExpression)JExpr._new((JClass)m.directClass(DrillDeferredObject.class.getCanonicalName())));
        }
        sub.assign((JAssignmentTarget)workspaceJVars[3], (JExpression)JExpr.newArray((JType)m._ref(DrillDeferredObject.class), (int)this.argTypes.length));
        sub.assign((JAssignmentTarget)workspaceJVars[1], (JExpression)this.getUDFInstance(m));
        JTryBlock udfInitTry = sub._try();
        udfInitTry.body().assign((JAssignmentTarget)workspaceJVars[0], (JExpression)workspaceJVars[1].invoke("initialize").arg((JExpression)oiArray));
        JCatchBlock udfInitCatch = udfInitTry._catch(m.directClass(Exception.class.getCanonicalName()));
        JVar exVar = udfInitCatch.param("ex");
        udfInitCatch.body()._throw((JExpression)JExpr._new((JClass)m.directClass(RuntimeException.class.getCanonicalName())).arg(JExpr.lit((String)String.format("Failed to initialize GenericUDF", new Object[0]))).arg((JExpression)exVar));
        sub.add((JStatement)ObjectInspectorHelper.initReturnValueHolder(g, m, workspaceJVars[4], this.returnOI, this.returnType.getMinorType()));
        JBlock setup = g.getBlock(ClassGenerator.BlockType.SETUP);
        setup.directStatement(String.format("/** start %s for function %s **/ ", ClassGenerator.BlockType.SETUP.name(), this.genericUdfClazz.getName() + (!this.isGenericUDF ? "(" + this.udfName + ")" : "")));
        setup.add((JStatement)sub);
        setup.directStatement(String.format("/** end %s for function %s **/ ", ClassGenerator.BlockType.SETUP.name(), this.genericUdfClazz.getName() + (!this.isGenericUDF ? "(" + this.udfName + ")" : "")));
    }

    private ClassGenerator.HoldingContainer generateEval(ClassGenerator<?> g, ClassGenerator.HoldingContainer[] inputVariables, JVar[] workspaceJVars) {
        ClassGenerator.HoldingContainer out = g.declare(this.returnType);
        JCodeModel m = g.getModel();
        JBlock sub = new JBlock(true, true);
        for (int i = 0; i < this.argTypes.length; ++i) {
            if (inputVariables[i].isOptional()) {
                sub.assign((JAssignmentTarget)workspaceJVars[3].component(JExpr.lit((int)i)), (JExpression)workspaceJVars[2].component(JExpr.lit((int)i)));
                JBlock conditionalBlock = new JBlock(false, false);
                JConditional jc = conditionalBlock._if(inputVariables[i].getIsSet().ne(JExpr.lit((int)0)));
                jc._then().assign((JAssignmentTarget)JExpr.ref((JExpression)workspaceJVars[3].component(JExpr.lit((int)i)), (String)"valueHolder"), (JExpression)inputVariables[i].getHolder());
                jc._else().assign((JAssignmentTarget)JExpr.ref((JExpression)workspaceJVars[3].component(JExpr.lit((int)i)), (String)"valueHolder"), JExpr._null());
                sub.add((JStatement)conditionalBlock);
                continue;
            }
            sub.assign((JAssignmentTarget)workspaceJVars[3].component(JExpr.lit((int)i)), (JExpression)workspaceJVars[2].component(JExpr.lit((int)i)));
            sub.assign((JAssignmentTarget)JExpr.ref((JExpression)workspaceJVars[3].component(JExpr.lit((int)i)), (String)"valueHolder"), (JExpression)inputVariables[i].getHolder());
        }
        JVar retVal = sub.decl(m._ref(Object.class), "ret");
        JTryBlock udfEvalTry = sub._try();
        udfEvalTry.body().assign((JAssignmentTarget)retVal, (JExpression)workspaceJVars[1].invoke("evaluate").arg((JExpression)workspaceJVars[3]));
        JCatchBlock udfEvalCatch = udfEvalTry._catch(m.directClass(Exception.class.getCanonicalName()));
        JVar exVar = udfEvalCatch.param("ex");
        udfEvalCatch.body()._throw((JExpression)JExpr._new((JClass)m.directClass(RuntimeException.class.getCanonicalName())).arg(JExpr.lit((String)String.format("GenericUDF.evaluate method failed", new Object[0]))).arg((JExpression)exVar));
        sub.add((JStatement)ObjectInspectorHelper.getDrillObject(m, this.returnOI, workspaceJVars[0], workspaceJVars[4], retVal));
        sub.assign((JAssignmentTarget)out.getHolder(), (JExpression)workspaceJVars[4]);
        JBlock setup = g.getBlock(ClassGenerator.BlockType.EVAL);
        setup.directStatement(String.format("/** start %s for function %s **/ ", ClassGenerator.BlockType.EVAL.name(), this.genericUdfClazz.getName() + (!this.isGenericUDF ? "(" + this.udfName + ")" : "")));
        setup.add((JStatement)sub);
        setup.directStatement(String.format("/** end %s for function %s **/ ", ClassGenerator.BlockType.EVAL.name(), this.genericUdfClazz.getName() + (!this.isGenericUDF ? "(" + this.udfName + ")" : "")));
        return out;
    }
}

