/*
 * Decompiled with CFR 0.152.
 */
package org.apache.statemachine;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StateMachineLogParser {
    static Pattern fsmPattern = Pattern.compile("FSM-(\\d+):");
    static Pattern hashcodePattern = Pattern.compile("(.+)@(.+)");
    static Pattern subclassPattern = Pattern.compile("(.+)\\$(.+)");
    static Pattern eventPattern = Pattern.compile("Received event (.+)@\\d+ in state (.+)@\\d+");
    static Pattern transitionPattern = Pattern.compile("State transition (.+) -> (.+)");

    static Map<String, List<String>> getFsmEventMap(BufferedReader f) throws IOException {
        String s = f.readLine();
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        while (s != null) {
            Matcher m = fsmPattern.matcher(s);
            if (m.find()) {
                String key = m.group(1);
                if (!map.containsKey(key)) {
                    map.put(key, new ArrayList());
                }
                ((List)map.get(key)).add(s);
            }
            s = f.readLine();
        }
        return map;
    }

    static String cleanupState(String state) {
        Matcher m = hashcodePattern.matcher(state);
        if (m.find()) {
            state = m.group(1);
        }
        if ((m = subclassPattern.matcher(state)).find()) {
            state = m.group(2);
        }
        return state;
    }

    static Set<Tuple> getStateTuples(Map<String, List<String>> fsms) {
        HashSet<Tuple> tuples = new HashSet<Tuple>();
        for (List<String> transitions : fsms.values()) {
            String currentEvent = null;
            for (String s : transitions) {
                Matcher m = eventPattern.matcher(s);
                if (m.find()) {
                    currentEvent = m.group(1);
                    continue;
                }
                m = transitionPattern.matcher(s);
                if (m.find()) {
                    if (currentEvent == null) {
                        System.err.println("event is null");
                    }
                    String state1 = m.group(1);
                    String state2 = m.group(2);
                    tuples.add(new Tuple(StateMachineLogParser.cleanupState(state1), currentEvent, StateMachineLogParser.cleanupState(state2)));
                    continue;
                }
                if (!s.contains("deferred")) continue;
                currentEvent = currentEvent + "[deferred]";
            }
        }
        return tuples;
    }

    static void drawDotGraph(Set<Tuple> tuples) {
        HashSet<String> states = new HashSet<String>();
        for (Tuple t : tuples) {
            states.add(t.state1);
            states.add(t.state2);
        }
        System.out.println("digraph finite_state_machine {");
        for (String s : states) {
            System.out.println("\tnode [ shape = circle ] " + s + ";");
        }
        for (Tuple t : tuples) {
            System.out.println("\t" + t.state1 + " -> " + t.state2 + " [ label = \"" + t.event + "\" ];");
        }
        System.out.println("}");
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            System.out.println("Usage: StateMachineLogParser <logfile> | dot -Tsvg ");
            System.exit(-1);
        }
        BufferedReader f = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(args[0]), Charset.forName("UTF-8")));
        Map<String, List<String>> fsms = StateMachineLogParser.getFsmEventMap(f);
        Set<Tuple> tuples = StateMachineLogParser.getStateTuples(fsms);
        StateMachineLogParser.drawDotGraph(tuples);
    }

    static class Tuple {
        final String state1;
        final String state2;
        final String event;

        Tuple(String state1, String event, String state2) {
            this.state1 = state1;
            this.state2 = state2;
            this.event = event;
        }

        public boolean equals(Object o) {
            if (o instanceof Tuple) {
                Tuple t = (Tuple)o;
                return this.state1.equals(t.state1) && this.state2.equals(t.state2) && this.event.equals(t.event);
            }
            return false;
        }

        public int hashCode() {
            return (this.state1 + this.event + this.state2).hashCode();
        }

        public String toString() {
            return this.state1 + " + " + this.event + " = " + this.state2;
        }
    }
}

