/*
 * Decompiled with CFR 0.152.
 */
package org.apache.omid.committable;

import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.omid.committable.CommitTable;
import org.apache.phoenix.thirdparty.com.google.common.base.Optional;
import org.apache.phoenix.thirdparty.com.google.common.util.concurrent.ListenableFuture;
import org.apache.phoenix.thirdparty.com.google.common.util.concurrent.SettableFuture;

public class InMemoryCommitTable
implements CommitTable {
    final ConcurrentHashMap<Long, Long> table = new ConcurrentHashMap();
    long lowWatermark;

    @Override
    public CommitTable.Writer getWriter() {
        return new Writer();
    }

    @Override
    public CommitTable.Client getClient() {
        return new Client();
    }

    public int countElements() {
        return this.table.size();
    }

    static long removeCheckpointBits(long startTimestamp) {
        return startTimestamp - startTimestamp % 50L;
    }

    public class Client
    implements CommitTable.Client {
        @Override
        public ListenableFuture<Optional<CommitTable.CommitTimestamp>> getCommitTimestamp(long startTimestamp) {
            startTimestamp = InMemoryCommitTable.removeCheckpointBits(startTimestamp);
            SettableFuture f = SettableFuture.create();
            Long result = InMemoryCommitTable.this.table.get(startTimestamp);
            if (result == null) {
                f.set((Object)Optional.absent());
            } else if (result == -1L) {
                f.set((Object)Optional.of((Object)new CommitTable.CommitTimestamp(CommitTable.CommitTimestamp.Location.COMMIT_TABLE, -1L, false)));
            } else {
                f.set((Object)Optional.of((Object)new CommitTable.CommitTimestamp(CommitTable.CommitTimestamp.Location.COMMIT_TABLE, result, true)));
            }
            return f;
        }

        @Override
        public ListenableFuture<Long> readLowWatermark() {
            SettableFuture f = SettableFuture.create();
            f.set((Object)InMemoryCommitTable.this.lowWatermark);
            return f;
        }

        @Override
        public ListenableFuture<Void> deleteCommitEntry(long startTimestamp) {
            startTimestamp = InMemoryCommitTable.removeCheckpointBits(startTimestamp);
            SettableFuture f = SettableFuture.create();
            InMemoryCommitTable.this.table.remove(startTimestamp);
            f.set(null);
            return f;
        }

        @Override
        public ListenableFuture<Boolean> tryInvalidateTransaction(long startTimestamp) {
            startTimestamp = InMemoryCommitTable.removeCheckpointBits(startTimestamp);
            SettableFuture f = SettableFuture.create();
            Long old = InMemoryCommitTable.this.table.get(startTimestamp);
            if (old == null) {
                old = InMemoryCommitTable.this.table.putIfAbsent(startTimestamp, -1L);
                if (old == null || old == -1L) {
                    f.set((Object)true);
                    return f;
                }
            } else if (old == -1L) {
                f.set((Object)true);
                return f;
            }
            f.set((Object)false);
            return f;
        }
    }

    public class Writer
    implements CommitTable.Writer {
        @Override
        public void addCommittedTransaction(long startTimestamp, long commitTimestamp) {
            InMemoryCommitTable.this.table.putIfAbsent(startTimestamp, commitTimestamp);
        }

        @Override
        public void updateLowWatermark(long lowWatermark) throws IOException {
            InMemoryCommitTable.this.lowWatermark = lowWatermark;
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void clearWriteBuffer() {
            InMemoryCommitTable.this.table.clear();
        }

        @Override
        public boolean atomicAddCommittedTransaction(long startTimestamp, long commitTimestamp) throws IOException {
            return InMemoryCommitTable.this.table.putIfAbsent(startTimestamp = InMemoryCommitTable.removeCheckpointBits(startTimestamp), commitTimestamp) == null;
        }
    }
}

