/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.tool.coprocessor;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.CoprocessorDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.tool.coprocessor.Branch1CoprocessorMethods;
import org.apache.hadoop.hbase.tool.coprocessor.CoprocessorMethods;
import org.apache.hadoop.hbase.tool.coprocessor.CoprocessorViolation;
import org.apache.hadoop.hbase.tool.coprocessor.CurrentCoprocessorMethods;
import org.apache.hadoop.hbase.util.AbstractHBaseTool;
import org.apache.hbase.thirdparty.org.apache.commons.cli.CommandLine;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"Tools"})
public class CoprocessorValidator
extends AbstractHBaseTool {
    private static final Logger LOG = LoggerFactory.getLogger(CoprocessorValidator.class);
    private CoprocessorMethods branch1 = new Branch1CoprocessorMethods();
    private CoprocessorMethods current = new CurrentCoprocessorMethods();
    private final List<String> jars = new ArrayList<String>();
    private final List<Pattern> tablePatterns = new ArrayList<Pattern>();
    private final List<String> classes = new ArrayList<String>();
    private boolean config;
    private boolean dieOnWarnings;

    private ResolverUrlClassLoader createClassLoader(URL[] urls) {
        return this.createClassLoader(urls, ((Object)((Object)this)).getClass().getClassLoader());
    }

    private ResolverUrlClassLoader createClassLoader(final URL[] urls, final ClassLoader parent) {
        return AccessController.doPrivileged(new PrivilegedAction<ResolverUrlClassLoader>(){

            @Override
            public ResolverUrlClassLoader run() {
                return new ResolverUrlClassLoader(urls, parent);
            }
        });
    }

    private ResolverUrlClassLoader createClassLoader(ClassLoader parent, Path path) throws IOException {
        java.nio.file.Path tempPath = Files.createTempFile("hbase-coprocessor-", ".jar", new FileAttribute[0]);
        Path destination = new Path(tempPath.toString());
        LOG.debug("Copying coprocessor jar '{}' to '{}'.", (Object)path, (Object)tempPath);
        FileSystem fileSystem = FileSystem.get((Configuration)this.getConf());
        fileSystem.copyToLocalFile(path, destination);
        URL url = tempPath.toUri().toURL();
        return this.createClassLoader(new URL[]{url}, parent);
    }

    private void validate(ClassLoader classLoader, String className, List<CoprocessorViolation> violations) {
        LOG.debug("Validating class '{}'.", (Object)className);
        try {
            Class<?> clazz = classLoader.loadClass(className);
            for (Method method : clazz.getDeclaredMethods()) {
                LOG.trace("Validating method '{}'.", (Object)method);
                if (!this.branch1.hasMethod(method) || this.current.hasMethod(method)) continue;
                CoprocessorViolation violation = new CoprocessorViolation(className, CoprocessorViolation.Severity.WARNING, "method '" + method + "' was removed from new coprocessor API, so it won't be called by HBase");
                violations.add(violation);
            }
        }
        catch (ClassNotFoundException e) {
            CoprocessorViolation violation = new CoprocessorViolation(className, CoprocessorViolation.Severity.ERROR, "no such class", e);
            violations.add(violation);
        }
        catch (Error | RuntimeException e) {
            CoprocessorViolation violation = new CoprocessorViolation(className, CoprocessorViolation.Severity.ERROR, "could not validate class", e);
            violations.add(violation);
        }
    }

    public void validateClasses(ClassLoader classLoader, List<String> classNames, List<CoprocessorViolation> violations) {
        for (String className : classNames) {
            this.validate(classLoader, className, violations);
        }
    }

    public void validateClasses(ClassLoader classLoader, String[] classNames, List<CoprocessorViolation> violations) {
        this.validateClasses(classLoader, Arrays.asList(classNames), violations);
    }

    @InterfaceAudience.Private
    protected void validateTables(ClassLoader classLoader, Admin admin, Pattern pattern, List<CoprocessorViolation> violations) throws IOException {
        List tableDescriptors = admin.listTableDescriptors(pattern);
        for (TableDescriptor tableDescriptor : tableDescriptors) {
            LOG.debug("Validating table {}", (Object)tableDescriptor.getTableName());
            Collection coprocessorDescriptors = tableDescriptor.getCoprocessorDescriptors();
            for (CoprocessorDescriptor coprocessorDescriptor : coprocessorDescriptors) {
                String className = coprocessorDescriptor.getClassName();
                Optional jarPath = coprocessorDescriptor.getJarPath();
                if (jarPath.isPresent()) {
                    Path path = new Path((String)jarPath.get());
                    try {
                        ResolverUrlClassLoader cpClassLoader = this.createClassLoader(classLoader, path);
                        Throwable throwable = null;
                        try {
                            this.validate(cpClassLoader, className, violations);
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (cpClassLoader == null) continue;
                            if (throwable != null) {
                                try {
                                    cpClassLoader.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            cpClassLoader.close();
                        }
                    }
                    catch (IOException e) {
                        CoprocessorViolation violation = new CoprocessorViolation(className, CoprocessorViolation.Severity.ERROR, "could not validate jar file '" + path + "'", e);
                        violations.add(violation);
                    }
                    continue;
                }
                this.validate(classLoader, className, violations);
            }
        }
    }

    private void validateTables(ClassLoader classLoader, Pattern pattern, List<CoprocessorViolation> violations) throws IOException {
        try (Connection connection = ConnectionFactory.createConnection((Configuration)this.getConf());
             Admin admin = connection.getAdmin();){
            this.validateTables(classLoader, admin, pattern, violations);
        }
    }

    protected void printUsage() {
        String header = "hbase pre-upgrade validate-cp [-jar ...] [-class ... | -table ... | -config]";
        this.printUsage(header, "Options:", "");
    }

    protected void addOptions() {
        this.addOptNoArg("e", "Treat warnings as errors.");
        this.addOptWithArg("jar", "Jar file/directory of the coprocessor.");
        this.addOptWithArg("table", "Table coprocessor(s) to check.");
        this.addOptWithArg("class", "Coprocessor class(es) to check.");
        this.addOptNoArg("config", "Obtain coprocessor class(es) from configuration.");
    }

    protected void processOptions(CommandLine cmd) {
        String[] classes;
        String[] tables;
        String[] jars = cmd.getOptionValues("jar");
        if (jars != null) {
            Collections.addAll(this.jars, jars);
        }
        if ((tables = cmd.getOptionValues("table")) != null) {
            Arrays.stream(tables).map(Pattern::compile).forEach(this.tablePatterns::add);
        }
        if ((classes = cmd.getOptionValues("class")) != null) {
            Collections.addAll(this.classes, classes);
        }
        this.config = cmd.hasOption("config");
        this.dieOnWarnings = cmd.hasOption("e");
    }

    private List<URL> buildClasspath(List<String> jars) throws IOException {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (String jar : jars) {
            java.nio.file.Path jarPath = Paths.get(jar, new String[0]);
            if (Files.isDirectory(jarPath, new LinkOption[0])) {
                Stream<java.nio.file.Path> stream = Files.list(jarPath);
                Throwable throwable = null;
                try {
                    List files = stream.filter(path -> Files.isRegularFile(path, new LinkOption[0])).collect(Collectors.toList());
                    for (java.nio.file.Path file : files) {
                        URL url = file.toUri().toURL();
                        urls.add(url);
                    }
                    continue;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (stream == null) continue;
                    if (throwable != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    stream.close();
                    continue;
                }
            }
            URL url = jarPath.toUri().toURL();
            urls.add(url);
        }
        return urls;
    }

    protected int doWork() throws Exception {
        if (this.tablePatterns.isEmpty() && this.classes.isEmpty() && !this.config) {
            LOG.error("Please give at least one -table, -class or -config parameter.");
            this.printUsage();
            return 1;
        }
        List<URL> urlList = this.buildClasspath(this.jars);
        URL[] urls = urlList.toArray(new URL[urlList.size()]);
        LOG.debug("Classpath: {}", urlList);
        ArrayList<CoprocessorViolation> violations = new ArrayList<CoprocessorViolation>();
        ResolverUrlClassLoader classLoader = this.createClassLoader(urls);
        Object object = null;
        try {
            for (Pattern tablePattern : this.tablePatterns) {
                this.validateTables(classLoader, tablePattern, violations);
            }
            this.validateClasses((ClassLoader)classLoader, this.classes, violations);
            if (this.config) {
                String[] regionCoprocessors;
                String[] masterCoprocessors = this.getConf().getStrings("hbase.coprocessor.master.classes");
                if (masterCoprocessors != null) {
                    this.validateClasses((ClassLoader)classLoader, masterCoprocessors, violations);
                }
                if ((regionCoprocessors = this.getConf().getStrings("hbase.coprocessor.region.classes")) != null) {
                    this.validateClasses((ClassLoader)classLoader, regionCoprocessors, violations);
                }
            }
        }
        catch (Throwable masterCoprocessors) {
            object = masterCoprocessors;
            throw masterCoprocessors;
        }
        finally {
            if (classLoader != null) {
                if (object != null) {
                    try {
                        classLoader.close();
                    }
                    catch (Throwable masterCoprocessors) {
                        ((Throwable)object).addSuppressed(masterCoprocessors);
                    }
                } else {
                    classLoader.close();
                }
            }
        }
        boolean error = false;
        for (CoprocessorViolation violation : violations) {
            String className = violation.getClassName();
            String message = violation.getMessage();
            Throwable throwable = violation.getThrowable();
            switch (violation.getSeverity()) {
                case WARNING: {
                    if (throwable == null) {
                        LOG.warn("Warning in class '{}': {}.", (Object)className, (Object)message);
                    } else {
                        LOG.warn("Warning in class '{}': {}.", new Object[]{className, message, throwable});
                    }
                    if (!this.dieOnWarnings) break;
                    error = true;
                    break;
                }
                case ERROR: {
                    if (throwable == null) {
                        LOG.error("Error in class '{}': {}.", (Object)className, (Object)message);
                    } else {
                        LOG.error("Error in class '{}': {}.", new Object[]{className, message, throwable});
                    }
                    error = true;
                }
            }
        }
        return error ? 1 : 0;
    }

    private static final class ResolverUrlClassLoader
    extends URLClassLoader {
        private ResolverUrlClassLoader(URL[] urls, ClassLoader parent) {
            super(urls, parent);
        }

        @Override
        public Class<?> loadClass(String name) throws ClassNotFoundException {
            return this.loadClass(name, true);
        }
    }
}

