/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import com.google.protobuf.Service;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentMap;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.TableDescriptors;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.locking.EntityLock;
import org.apache.hadoop.hbase.executor.ExecutorService;
import org.apache.hadoop.hbase.io.hfile.BlockCache;
import org.apache.hadoop.hbase.ipc.RpcServerInterface;
import org.apache.hadoop.hbase.mob.MobFileCache;
import org.apache.hadoop.hbase.quotas.RegionServerRpcQuotaManager;
import org.apache.hadoop.hbase.quotas.RegionServerSpaceQuotaManager;
import org.apache.hadoop.hbase.quotas.RegionSizeStore;
import org.apache.hadoop.hbase.regionserver.FavoredNodesForRegion;
import org.apache.hadoop.hbase.regionserver.FlushRequester;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HeapMemoryManager;
import org.apache.hadoop.hbase.regionserver.LeaseManager;
import org.apache.hadoop.hbase.regionserver.MetricsRegionServer;
import org.apache.hadoop.hbase.regionserver.MutableOnlineRegions;
import org.apache.hadoop.hbase.regionserver.RegionServerAccounting;
import org.apache.hadoop.hbase.regionserver.SecureBulkLoadManager;
import org.apache.hadoop.hbase.regionserver.ServerNonceManager;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionRequester;
import org.apache.hadoop.hbase.regionserver.throttle.ThroughputController;
import org.apache.hadoop.hbase.security.access.AccessChecker;
import org.apache.hadoop.hbase.security.access.ZKPermissionWatcher;
import org.apache.hadoop.hbase.shaded.protobuf.generated.RegionServerStatusProtos;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public interface RegionServerServices
extends Server,
MutableOnlineRegions,
FavoredNodesForRegion {
    public WAL getWAL(RegionInfo var1) throws IOException;

    public List<WAL> getWALs() throws IOException;

    public FlushRequester getFlushRequester();

    public CompactionRequester getCompactionRequestor();

    public RegionServerAccounting getRegionServerAccounting();

    public RegionServerRpcQuotaManager getRegionServerRpcQuotaManager();

    public SecureBulkLoadManager getSecureBulkLoadManager();

    public RegionServerSpaceQuotaManager getRegionServerSpaceQuotaManager();

    public void postOpenDeployTasks(PostOpenDeployContext var1) throws IOException;

    public boolean reportRegionStateTransition(RegionStateTransitionContext var1);

    public RpcServerInterface getRpcServer();

    public ConcurrentMap<byte[], Boolean> getRegionsInTransitionInRS();

    public LeaseManager getLeaseManager();

    public ExecutorService getExecutorService();

    public ServerNonceManager getNonceManager();

    public boolean registerService(Service var1);

    public HeapMemoryManager getHeapMemoryManager();

    public double getCompactionPressure();

    public ThroughputController getFlushThroughputController();

    @Deprecated
    public double getFlushPressure();

    public MetricsRegionServer getMetrics();

    public EntityLock regionLock(List<RegionInfo> var1, String var2, Abortable var3) throws IOException;

    public void unassign(byte[] var1) throws IOException;

    public boolean isClusterUp();

    public TableDescriptors getTableDescriptors();

    public Optional<BlockCache> getBlockCache();

    public Optional<MobFileCache> getMobFileCache();

    public AccessChecker getAccessChecker();

    public ZKPermissionWatcher getZKPermissionWatcher();

    public boolean reportRegionSizesForQuotas(RegionSizeStore var1);

    public boolean reportFileArchivalForQuotas(TableName var1, Collection<Map.Entry<String, Long>> var2);

    public static class RegionStateTransitionContext {
        private final RegionServerStatusProtos.RegionStateTransition.TransitionCode code;
        private final long openSeqNum;
        private final long masterSystemTime;
        private final long[] procIds;
        private final RegionInfo[] hris;

        public RegionStateTransitionContext(RegionServerStatusProtos.RegionStateTransition.TransitionCode code, long openSeqNum, long masterSystemTime, RegionInfo ... hris) {
            this.code = code;
            this.openSeqNum = openSeqNum;
            this.masterSystemTime = masterSystemTime;
            this.hris = hris;
            this.procIds = new long[hris.length];
        }

        public RegionStateTransitionContext(RegionServerStatusProtos.RegionStateTransition.TransitionCode code, long openSeqNum, long procId, long masterSystemTime, RegionInfo hri) {
            this.code = code;
            this.openSeqNum = openSeqNum;
            this.masterSystemTime = masterSystemTime;
            this.hris = new RegionInfo[]{hri};
            this.procIds = new long[]{procId};
        }

        public RegionServerStatusProtos.RegionStateTransition.TransitionCode getCode() {
            return this.code;
        }

        public long getOpenSeqNum() {
            return this.openSeqNum;
        }

        public long getMasterSystemTime() {
            return this.masterSystemTime;
        }

        public RegionInfo[] getHris() {
            return this.hris;
        }

        public long[] getProcIds() {
            return this.procIds;
        }
    }

    public static class PostOpenDeployContext {
        private final HRegion region;
        private final long openProcId;
        private final long masterSystemTime;

        public PostOpenDeployContext(HRegion region, long openProcId, long masterSystemTime) {
            this.region = region;
            this.openProcId = openProcId;
            this.masterSystemTime = masterSystemTime;
        }

        public HRegion getRegion() {
            return this.region;
        }

        public long getOpenProcId() {
            return this.openProcId;
        }

        public long getMasterSystemTime() {
            return this.masterSystemTime;
        }
    }
}

