/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.balancer;

import org.apache.hadoop.hbase.master.balancer.BalanceAction;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class SwapRegionsAction
extends BalanceAction {
    private final int fromServer;
    private final int fromRegion;
    private final int toServer;
    private final int toRegion;

    SwapRegionsAction(int fromServer, int fromRegion, int toServer, int toRegion) {
        super(BalanceAction.Type.SWAP_REGIONS);
        this.fromServer = fromServer;
        this.fromRegion = fromRegion;
        this.toServer = toServer;
        this.toRegion = toRegion;
    }

    public int getFromServer() {
        return this.fromServer;
    }

    public int getFromRegion() {
        return this.fromRegion;
    }

    public int getToServer() {
        return this.toServer;
    }

    public int getToRegion() {
        return this.toRegion;
    }

    @Override
    public BalanceAction undoAction() {
        return new SwapRegionsAction(this.fromServer, this.toRegion, this.toServer, this.fromRegion);
    }

    @Override
    public String toString() {
        return (Object)((Object)this.getType()) + ": " + this.fromRegion + ":" + this.fromServer + " <-> " + this.toRegion + ":" + this.toServer;
    }
}

