/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.balancer;

import org.apache.hadoop.hbase.master.balancer.BalanceAction;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
class MoveRegionAction
extends BalanceAction {
    private final int region;
    private final int fromServer;
    private final int toServer;

    public MoveRegionAction(int region, int fromServer, int toServer) {
        super(BalanceAction.Type.MOVE_REGION);
        this.fromServer = fromServer;
        this.region = region;
        this.toServer = toServer;
    }

    public int getRegion() {
        return this.region;
    }

    public int getFromServer() {
        return this.fromServer;
    }

    public int getToServer() {
        return this.toServer;
    }

    @Override
    public BalanceAction undoAction() {
        return new MoveRegionAction(this.region, this.toServer, this.fromServer);
    }

    @Override
    public String toString() {
        return (Object)((Object)this.getType()) + ": " + this.region + ":" + this.fromServer + " -> " + this.toServer;
    }
}

