/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.cassandra.schema;

import org.apache.calcite.adapter.cassandra.CassandraSchemaFactory;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaFactory;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.common.logical.StoragePluginConfig;
import org.apache.drill.exec.store.AbstractSchemaFactory;
import org.apache.drill.exec.store.SchemaConfig;
import org.apache.drill.exec.store.StoragePlugin;
import org.apache.drill.exec.store.cassandra.CassandraStoragePlugin;
import org.apache.drill.exec.store.cassandra.schema.CassandraRootDrillSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraRootDrillSchemaFactory
extends AbstractSchemaFactory {
    private static final Logger logger = LoggerFactory.getLogger(CassandraRootDrillSchemaFactory.class);
    private final CassandraStoragePlugin plugin;
    private final SchemaFactory calciteSchemaFactory;

    public CassandraRootDrillSchemaFactory(String name, CassandraStoragePlugin plugin) {
        super(name);
        this.plugin = plugin;
        this.calciteSchemaFactory = new CassandraSchemaFactory();
    }

    public void registerSchemas(SchemaConfig schemaConfig, SchemaPlus parent) {
        CassandraRootDrillSchema schema;
        if (this.plugin.getConfig().getAuthMode() == StoragePluginConfig.AuthMode.SHARED_USER) {
            schema = new CassandraRootDrillSchema(this.getName(), (StoragePlugin)this.plugin, this.calciteSchemaFactory, parent, this.getName(), this.plugin.getConfig().toConfigMap());
        } else if (this.plugin.getConfig().getAuthMode() == StoragePluginConfig.AuthMode.USER_TRANSLATION) {
            schema = new CassandraRootDrillSchema(this.getName(), (StoragePlugin)this.plugin, this.calciteSchemaFactory, parent, this.getName(), this.plugin.getConfig().toConfigMap(schemaConfig.getUserName()));
        } else {
            throw UserException.internalError().message("Cassandra only supports SHARED_USER and USER_TRANSLATION authentication.", new Object[0]).build(logger);
        }
        parent.add(this.getName(), (Schema)schema);
    }
}

