/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.cassandra.schema;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.calcite.DataContext;
import org.apache.calcite.adapter.cassandra.CassandraSchema;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaFactory;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.util.BuiltInMethod;
import org.apache.drill.exec.store.AbstractSchema;
import org.apache.drill.exec.store.StoragePlugin;
import org.apache.drill.exec.store.cassandra.schema.CassandraDrillSchema;

public class CassandraRootDrillSchema
extends AbstractSchema {
    private final Map<String, Schema> schemas = new ConcurrentHashMap<String, Schema>();
    private final StoragePlugin plugin;
    private final SchemaFactory schemaFactory;
    private final SchemaPlus parent;
    private final String parentName;
    private final Map<String, Object> configMap;

    public CassandraRootDrillSchema(String name, StoragePlugin plugin, SchemaFactory schemaFactory, SchemaPlus parent, String parentName, Map<String, Object> configMap) {
        super(Collections.emptyList(), name);
        this.plugin = plugin;
        this.schemaFactory = schemaFactory;
        this.parent = parent;
        this.parentName = parentName;
        this.configMap = configMap;
    }

    public String getTypeName() {
        return "cassandra";
    }

    public Schema getSubSchema(String name) {
        return this.schemas.computeIfAbsent(name, this::createSubSchema);
    }

    private Schema createSubSchema(String schemaName) {
        HashMap<String, Object> configs = new HashMap<String, Object>(this.configMap);
        configs.put("keyspace", schemaName);
        SchemaPlus parentSchema = this.parent.getSubSchema(this.parentName);
        CassandraDrillSchema schema = new CassandraDrillSchema(schemaName, this.plugin, (CassandraSchema)this.schemaFactory.create(parentSchema, schemaName, configs));
        parentSchema.add(schemaName, (Schema)schema);
        return schema;
    }

    public Expression getExpression(SchemaPlus parentSchema, String name) {
        return Expressions.call((Expression)DataContext.ROOT, (Method)BuiltInMethod.DATA_CONTEXT_GET_ROOT_SCHEMA.method, (Expression[])new Expression[0]);
    }
}

