/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf.object.message;

import io.jhdf.Superblock;
import io.jhdf.Utils;
import io.jhdf.exceptions.HdfException;
import java.nio.ByteBuffer;
import java.util.BitSet;
import java.util.stream.IntStream;
import org.apache.commons.lang3.ArrayUtils;

public class DataSpace {
    private final byte version;
    private final boolean maxSizesPresent;
    private final int[] dimensions;
    private final long[] maxSizes;
    private final byte type;
    private final long totalLength;

    private DataSpace(ByteBuffer bb, Superblock sb) {
        int i;
        this.version = bb.get();
        int numberOfDimensions = bb.get();
        byte[] flagBits = new byte[1];
        bb.get(flagBits);
        BitSet flags = BitSet.valueOf(flagBits);
        this.maxSizesPresent = flags.get(0);
        if (this.version == 1) {
            bb.position(bb.position() + 5);
            this.type = (byte)-1;
        } else if (this.version == 2) {
            this.type = bb.get();
        } else {
            throw new HdfException("Unrecognized version = " + this.version);
        }
        if (numberOfDimensions != 0) {
            this.dimensions = new int[numberOfDimensions];
            for (i = 0; i < numberOfDimensions; ++i) {
                this.dimensions[i] = Utils.readBytesAsUnsignedInt(bb, sb.getSizeOfLengths());
            }
        } else {
            this.dimensions = new int[0];
        }
        if (this.maxSizesPresent) {
            this.maxSizes = new long[numberOfDimensions];
            for (i = 0; i < numberOfDimensions; ++i) {
                this.maxSizes[i] = Utils.readBytesAsUnsignedLong(bb, sb.getSizeOfLengths());
            }
        } else {
            this.maxSizes = new long[0];
        }
        this.totalLength = this.type == 2 ? 0L : IntStream.of(this.dimensions).mapToLong(Long::valueOf).reduce(1L, Math::multiplyExact);
    }

    public static DataSpace readDataSpace(ByteBuffer bb, Superblock sb) {
        return new DataSpace(bb, sb);
    }

    public long getTotalLength() {
        return this.totalLength;
    }

    public int getType() {
        return this.type;
    }

    public int getVersion() {
        return this.version;
    }

    public int[] getDimensions() {
        return ArrayUtils.clone((int[])this.dimensions);
    }

    public long[] getMaxSizes() {
        return ArrayUtils.clone((long[])this.maxSizes);
    }

    public boolean isMaxSizesPresent() {
        return this.maxSizesPresent;
    }
}

