/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf.dataset;

import io.jhdf.ObjectHeader;
import io.jhdf.api.Group;
import io.jhdf.api.dataset.ContiguousDataset;
import io.jhdf.dataset.DatasetBase;
import io.jhdf.exceptions.HdfException;
import io.jhdf.object.message.DataLayoutMessage;
import io.jhdf.storage.HdfBackingStorage;
import java.nio.ByteBuffer;

public class ContiguousDatasetImpl
extends DatasetBase
implements ContiguousDataset {
    final DataLayoutMessage.ContiguousDataLayoutMessage contiguousDataLayoutMessage = this.getHeaderMessage(DataLayoutMessage.ContiguousDataLayoutMessage.class);

    public ContiguousDatasetImpl(HdfBackingStorage hdfBackingStorage, long address, String name, Group parent, ObjectHeader oh) {
        super(hdfBackingStorage, address, name, parent, oh);
    }

    @Override
    public ByteBuffer getDataBuffer() {
        try {
            ByteBuffer data = this.hdfBackingStorage.map(this.contiguousDataLayoutMessage.getAddress(), this.getSizeInBytes());
            this.convertToCorrectEndiness(data);
            return data;
        }
        catch (Exception e) {
            throw new HdfException("Failed to map data buffer for dataset '" + this.getPath() + "'", e);
        }
    }

    @Override
    public ByteBuffer getBuffer() {
        return this.getDataBuffer();
    }

    @Override
    public long getDataAddress() {
        return this.contiguousDataLayoutMessage.getAddress();
    }

    @Override
    public boolean isEmpty() {
        return this.contiguousDataLayoutMessage.getAddress() == -1L;
    }
}

