/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf.btree.record;

import io.jhdf.Utils;
import io.jhdf.btree.record.BTreeRecord;
import io.jhdf.exceptions.HdfException;
import java.nio.ByteBuffer;
import java.util.BitSet;

public class AttributeNameForIndexedAttributesRecord
extends BTreeRecord {
    private final ByteBuffer heapId;
    private final BitSet flags;
    private final long creationOrder;
    private final long hash;

    public AttributeNameForIndexedAttributesRecord(ByteBuffer bb) {
        if (bb.remaining() != 17) {
            throw new HdfException("Invalid length buffer for AttributeNameForIndexedAttributesRecord. remaining bytes = " + bb.remaining());
        }
        this.heapId = Utils.createSubBuffer(bb, 8);
        this.flags = BitSet.valueOf(new byte[]{bb.get()});
        this.creationOrder = Utils.readBytesAsUnsignedLong(bb, 4);
        this.hash = Utils.readBytesAsUnsignedLong(bb, 4);
    }

    public ByteBuffer getHeapId() {
        return this.heapId;
    }

    public BitSet getFlags() {
        return this.flags;
    }

    public long getCreationOrder() {
        return this.creationOrder;
    }

    public long getHash() {
        return this.hash;
    }
}

