/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf.btree;

import io.jhdf.Utils;
import io.jhdf.btree.record.BTreeRecord;
import io.jhdf.checksum.ChecksumUtils;
import io.jhdf.dataset.chunked.DatasetInfo;
import io.jhdf.exceptions.HdfException;
import io.jhdf.storage.HdfBackingStorage;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class BTreeV2<T extends BTreeRecord> {
    private static final int NODE_OVERHEAD_BYTES = 10;
    private static final byte[] BTREE_NODE_V2_SIGNATURE = "BTHD".getBytes(StandardCharsets.US_ASCII);
    private static final byte[] BTREE_INTERNAL_NODE_SIGNATURE = "BTIN".getBytes(StandardCharsets.US_ASCII);
    private static final byte[] BTREE_LEAF_NODE_SIGNATURE = "BTLF".getBytes(StandardCharsets.US_ASCII);
    private final long address;
    private final int nodeType;
    private final List<T> records;
    private final int nodeSize;
    private final int recordSize;

    public List<T> getRecords() {
        return this.records;
    }

    public BTreeV2(HdfBackingStorage hdfBackingStorage, long address) {
        this(hdfBackingStorage, address, null);
    }

    public BTreeV2(HdfBackingStorage hdfBackingStorage, long address, DatasetInfo datasetInfo) {
        this.address = address;
        try {
            int headerSize = 16 + hdfBackingStorage.getSizeOfOffsets() + 2 + hdfBackingStorage.getSizeOfLengths() + 4;
            ByteBuffer bb = hdfBackingStorage.readBufferFromAddress(address, headerSize);
            byte[] formatSignatureBytes = new byte[4];
            bb.get(formatSignatureBytes, 0, formatSignatureBytes.length);
            if (!Arrays.equals(BTREE_NODE_V2_SIGNATURE, formatSignatureBytes)) {
                throw new HdfException("B tree V2 node signature not matched");
            }
            byte version = bb.get();
            if (version != 0) {
                throw new HdfException("Unsupported B tree v2 version detected. Version: " + version);
            }
            this.nodeType = bb.get();
            if ((this.nodeType == 10 || this.nodeType == 11) && datasetInfo == null) {
                throw new HdfException("datasetInfo not set when building chunk B tree");
            }
            this.nodeSize = Utils.readBytesAsUnsignedInt(bb, 4);
            this.recordSize = Utils.readBytesAsUnsignedInt(bb, 2);
            int depth = Utils.readBytesAsUnsignedInt(bb, 2);
            int splitPercent = Utils.readBytesAsUnsignedInt(bb, 1);
            int mergePercent = Utils.readBytesAsUnsignedInt(bb, 1);
            long rootNodeAddress = Utils.readBytesAsUnsignedLong(bb, hdfBackingStorage.getSizeOfOffsets());
            int numberOfRecordsInRoot = Utils.readBytesAsUnsignedInt(bb, 2);
            int totalNumberOfRecordsInTree = Utils.readBytesAsUnsignedInt(bb, hdfBackingStorage.getSizeOfLengths());
            bb.rewind();
            ChecksumUtils.validateChecksum(bb);
            this.records = new ArrayList<T>(totalNumberOfRecordsInTree);
            this.readRecords(hdfBackingStorage, rootNodeAddress, depth, numberOfRecordsInRoot, totalNumberOfRecordsInTree, datasetInfo);
        }
        catch (HdfException e) {
            throw new HdfException("Error reading B Tree node", e);
        }
    }

    private void readRecords(HdfBackingStorage hdfBackingStorage, long address, int depth, int numberOfRecords, int totalRecords, DatasetInfo datasetInfo) {
        int i;
        boolean leafNode;
        ByteBuffer bb = hdfBackingStorage.readBufferFromAddress(address, this.nodeSize);
        byte[] nodeSignatureBytes = new byte[4];
        bb.get(nodeSignatureBytes, 0, nodeSignatureBytes.length);
        if (Arrays.equals(BTREE_INTERNAL_NODE_SIGNATURE, nodeSignatureBytes)) {
            leafNode = false;
        } else if (Arrays.equals(BTREE_LEAF_NODE_SIGNATURE, nodeSignatureBytes)) {
            leafNode = true;
        } else {
            throw new HdfException("B tree internal node signature not matched");
        }
        byte version = bb.get();
        if (version != 0) {
            throw new HdfException("Unsupported B tree v2 internal node version detected. Version: " + version);
        }
        byte type = bb.get();
        for (i = 0; i < numberOfRecords; ++i) {
            this.records.add(BTreeRecord.readRecord(type, Utils.createSubBuffer(bb, this.recordSize), datasetInfo));
        }
        if (!leafNode) {
            for (i = 0; i < numberOfRecords + 1; ++i) {
                long childAddress = Utils.readBytesAsUnsignedLong(bb, hdfBackingStorage.getSizeOfOffsets());
                int sizeOfNumberOfRecords = this.getSizeOfNumberOfRecords(this.nodeSize, depth, totalRecords, this.recordSize, hdfBackingStorage.getSizeOfOffsets());
                int numberOfChildRecords = Utils.readBytesAsUnsignedInt(bb, sizeOfNumberOfRecords);
                int totalNumberOfChildRecords = depth > 1 ? Utils.readBytesAsUnsignedInt(bb, this.getSizeOfTotalNumberOfChildRecords(this.nodeSize, depth, this.recordSize)) : -1;
                this.readRecords(hdfBackingStorage, childAddress, depth - 1, numberOfChildRecords, totalNumberOfChildRecords, datasetInfo);
            }
        }
        bb.limit(bb.position() + 4);
        bb.rewind();
        ChecksumUtils.validateChecksum(bb);
    }

    private int getSizeOfNumberOfRecords(int nodeSize, int depth, int totalRecords, int recordSize, int sizeOfOffsets) {
        int size = nodeSize - 10;
        if (depth > 1) {
            int pointerTripletBytes = this.bytesNeededToHoldNumber(totalRecords) * 2 + sizeOfOffsets;
            return this.bytesNeededToHoldNumber((size -= pointerTripletBytes) / recordSize);
        }
        return this.bytesNeededToHoldNumber(size / recordSize);
    }

    private int bytesNeededToHoldNumber(int number) {
        return (Integer.numberOfTrailingZeros(Integer.highestOneBit(number)) + 8) / 8;
    }

    private int getSizeOfTotalNumberOfChildRecords(int nodeSize, int depth, int recordSize) {
        int recordsInLeafNode = nodeSize / recordSize;
        return (BigInteger.valueOf(recordsInLeafNode).pow(depth).bitLength() + 8) / 8;
    }

    public String toString() {
        return "BTreeNodeV2 [address=" + this.address + ", nodeType=" + this.nodeType + "]";
    }
}

