/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf;

import io.jhdf.Utils;
import io.jhdf.checksum.ChecksumUtils;
import io.jhdf.exceptions.HdfException;
import io.jhdf.object.message.Message;
import io.jhdf.object.message.ObjectHeaderContinuationMessage;
import io.jhdf.storage.HdfBackingStorage;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.concurrent.LazyInitializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ObjectHeader {
    private static final Logger logger = LoggerFactory.getLogger(ObjectHeader.class);
    private final long address;
    protected final List<Message> messages = new ArrayList<Message>();

    public long getAddress() {
        return this.address;
    }

    public abstract int getVersion();

    public abstract boolean isAttributeCreationOrderTracked();

    public abstract boolean isAttributeCreationOrderIndexed();

    public List<Message> getMessages() {
        return this.messages;
    }

    protected ObjectHeader(long address) {
        this.address = address;
    }

    public <T extends Message> List<T> getMessagesOfType(Class<T> type) {
        return this.getMessages().stream().filter(type::isInstance).map(type::cast).collect(Collectors.toList());
    }

    public <T extends Message> boolean hasMessageOfType(Class<T> type) {
        return !this.getMessagesOfType(type).isEmpty();
    }

    public <T extends Message> T getMessageOfType(Class<T> type) {
        List<T> messagesOfType = this.getMessagesOfType(type);
        if (messagesOfType.isEmpty()) {
            throw new HdfException("Requested message type '" + type.getSimpleName() + "' not present");
        }
        if (messagesOfType.size() > 1) {
            throw new HdfException("Requested message type '" + type.getSimpleName() + "' is not unique");
        }
        return (T)((Message)messagesOfType.get(0));
    }

    public static ObjectHeader readObjectHeader(HdfBackingStorage hdfBackingStorage, long address) {
        ByteBuffer bb = hdfBackingStorage.readBufferFromAddress(address, 1);
        byte version = bb.get();
        if (version == 1) {
            return new ObjectHeaderV1(hdfBackingStorage, address);
        }
        return new ObjectHeaderV2(hdfBackingStorage, address);
    }

    public static LazyInitializer<ObjectHeader> lazyReadObjectHeader(final HdfBackingStorage hdfBackingStorage, final long address) {
        logger.debug("Creating lazy object header at address: {}", (Object)address);
        return new LazyInitializer<ObjectHeader>(){

            protected ObjectHeader initialize() {
                logger.debug("Lazy initializing object header at address: {}", (Object)address);
                return ObjectHeader.readObjectHeader(hdfBackingStorage, address);
            }
        };
    }

    public static class ObjectHeaderV2
    extends ObjectHeader {
        private static final byte[] OBJECT_HEADER_V2_SIGNATURE = "OHDR".getBytes(StandardCharsets.US_ASCII);
        private static final byte[] OBJECT_HEADER_V2_CONTINUATION_SIGNATURE = "OCHK".getBytes(StandardCharsets.US_ASCII);
        private static final int ATTRIBUTE_CREATION_ORDER_TRACKED = 2;
        private static final int ATTRIBUTE_CREATION_ORDER_INDEXED = 3;
        private static final int NUMBER_OF_ATTRIBUTES_PRESENT = 4;
        private static final int TIMESTAMPS_PRESENT = 5;
        private final byte version;
        private final long accessTime;
        private final long modificationTime;
        private final long changeTime;
        private final long birthTime;
        private final int maximumNumberOfCompactAttributes;
        private final int maximumNumberOfDenseAttributes;
        private final BitSet flags;

        private ObjectHeaderV2(HdfBackingStorage hdfBackingStorage, long address) {
            super(address);
            int headerSize = 0;
            try {
                ByteBuffer bb = hdfBackingStorage.readBufferFromAddress(address, 6);
                address += 6L;
                headerSize += 6;
                byte[] formatSignatureBytes = new byte[OBJECT_HEADER_V2_SIGNATURE.length];
                bb.get(formatSignatureBytes);
                if (!Arrays.equals(OBJECT_HEADER_V2_SIGNATURE, formatSignatureBytes)) {
                    throw new HdfException("Object header v2 signature not matched");
                }
                this.version = bb.get();
                if (this.version != 2) {
                    throw new HdfException("Invalid version detected. Version is = " + this.version);
                }
                this.flags = BitSet.valueOf(new byte[]{bb.get()});
                int sizeOfChunk0 = this.flags.get(1) ? (this.flags.get(0) ? 8 : 4) : (this.flags.get(0) ? 2 : 1);
                if (this.flags.get(5)) {
                    bb = hdfBackingStorage.readBufferFromAddress(address, 16);
                    address += 16L;
                    headerSize += 16;
                    this.accessTime = Utils.readBytesAsUnsignedLong(bb, 4);
                    this.modificationTime = Utils.readBytesAsUnsignedLong(bb, 4);
                    this.changeTime = Utils.readBytesAsUnsignedLong(bb, 4);
                    this.birthTime = Utils.readBytesAsUnsignedLong(bb, 4);
                } else {
                    this.accessTime = -1L;
                    this.modificationTime = -1L;
                    this.changeTime = -1L;
                    this.birthTime = -1L;
                }
                if (this.flags.get(4)) {
                    bb = hdfBackingStorage.readBufferFromAddress(address, 4);
                    address += 4L;
                    headerSize += 4;
                    this.maximumNumberOfCompactAttributes = Utils.readBytesAsUnsignedInt(bb, 2);
                    this.maximumNumberOfDenseAttributes = Utils.readBytesAsUnsignedInt(bb, 2);
                } else {
                    this.maximumNumberOfCompactAttributes = -1;
                    this.maximumNumberOfDenseAttributes = -1;
                }
                bb = hdfBackingStorage.readBufferFromAddress(address, sizeOfChunk0);
                headerSize += sizeOfChunk0;
                int sizeOfMessages = Utils.readBytesAsUnsignedInt(bb, sizeOfChunk0);
                bb = hdfBackingStorage.readBufferFromAddress(address += (long)sizeOfChunk0, sizeOfMessages);
                headerSize += sizeOfMessages;
                this.readMessages(hdfBackingStorage, bb);
                ByteBuffer fullHeaderBuffer = hdfBackingStorage.readBufferFromAddress(super.getAddress(), headerSize += 4);
                ChecksumUtils.validateChecksum(fullHeaderBuffer);
                logger.debug("Read object header from address: {}", (Object)address);
            }
            catch (Exception e) {
                throw new HdfException("Failed to read object header at address: " + address, e);
            }
        }

        private void readMessages(HdfBackingStorage hdfBackingStorage, ByteBuffer bb) {
            while (bb.remaining() >= 8) {
                Message m = Message.readObjectHeaderV2Message(bb, hdfBackingStorage, this.isAttributeCreationOrderTracked());
                this.messages.add(m);
                if (!(m instanceof ObjectHeaderContinuationMessage)) continue;
                ObjectHeaderContinuationMessage ohcm = (ObjectHeaderContinuationMessage)m;
                ByteBuffer continuationBuffer = hdfBackingStorage.readBufferFromAddress(ohcm.getOffset(), ohcm.getLength());
                byte[] continuationSignatureBytes = new byte[OBJECT_HEADER_V2_CONTINUATION_SIGNATURE.length];
                continuationBuffer.get(continuationSignatureBytes);
                if (!Arrays.equals(OBJECT_HEADER_V2_CONTINUATION_SIGNATURE, continuationSignatureBytes)) {
                    throw new HdfException("Object header continuation header not matched, at address: " + ohcm.getOffset());
                }
                this.readMessages(hdfBackingStorage, continuationBuffer);
                continuationBuffer.rewind();
                ChecksumUtils.validateChecksum(continuationBuffer);
            }
        }

        @Override
        public int getVersion() {
            return this.version;
        }

        public long getAccessTime() {
            return this.accessTime;
        }

        public long getModificationTime() {
            return this.modificationTime;
        }

        public long getChangeTime() {
            return this.changeTime;
        }

        public long getBirthTime() {
            return this.birthTime;
        }

        public int getMaximumNumberOfCompactAttributes() {
            return this.maximumNumberOfCompactAttributes;
        }

        public int getMaximumNumberOfDenseAttributes() {
            return this.maximumNumberOfDenseAttributes;
        }

        @Override
        public boolean isAttributeCreationOrderTracked() {
            return this.flags.get(2);
        }

        @Override
        public boolean isAttributeCreationOrderIndexed() {
            return this.flags.get(3);
        }
    }

    public static class ObjectHeaderV1
    extends ObjectHeader {
        private final byte version;
        private final int referenceCount;

        private ObjectHeaderV1(HdfBackingStorage hdfBackingStorage, long address) {
            super(address);
            try {
                ByteBuffer header = hdfBackingStorage.readBufferFromAddress(address, 12);
                this.version = header.get();
                if (this.version != 1) {
                    throw new HdfException("Invalid version detected. Version is = " + this.version);
                }
                header.position(header.position() + 1);
                int numberOfMessages = Utils.readBytesAsUnsignedInt(header, 2);
                this.referenceCount = Utils.readBytesAsUnsignedInt(header, 4);
                int headerSize = Utils.readBytesAsUnsignedInt(header, 4);
                header = hdfBackingStorage.readBufferFromAddress(address += 16L, headerSize);
                this.readMessages(hdfBackingStorage, header, numberOfMessages);
                logger.debug("Read object header from address: {}", (Object)address);
            }
            catch (Exception e) {
                throw new HdfException("Failed to read object header at address: " + address, e);
            }
        }

        private void readMessages(HdfBackingStorage hdfBackingStorage, ByteBuffer bb, int numberOfMessages) {
            while (bb.remaining() > 4 && this.messages.size() < numberOfMessages) {
                Message m = Message.readObjectHeaderV1Message(bb, hdfBackingStorage);
                this.messages.add(m);
                if (!(m instanceof ObjectHeaderContinuationMessage)) continue;
                ObjectHeaderContinuationMessage ohcm = (ObjectHeaderContinuationMessage)m;
                ByteBuffer continuationBuffer = hdfBackingStorage.readBufferFromAddress(ohcm.getOffset(), ohcm.getLength());
                this.readMessages(hdfBackingStorage, continuationBuffer, numberOfMessages);
            }
        }

        @Override
        public int getVersion() {
            return this.version;
        }

        public int getReferenceCount() {
            return this.referenceCount;
        }

        @Override
        public boolean isAttributeCreationOrderTracked() {
            return false;
        }

        @Override
        public boolean isAttributeCreationOrderIndexed() {
            return false;
        }
    }
}

