/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.delta.format;

import io.delta.standalone.DeltaLog;
import org.apache.drill.common.logical.FormatPluginConfig;
import org.apache.drill.exec.planner.logical.DrillTable;
import org.apache.drill.exec.planner.logical.DrillTableSelection;
import org.apache.drill.exec.store.SchemaConfig;
import org.apache.drill.exec.store.StoragePlugin;
import org.apache.drill.exec.store.delta.format.DeltaFormatPlugin;
import org.apache.drill.exec.store.dfs.DrillFileSystem;
import org.apache.drill.exec.store.dfs.FileSelection;
import org.apache.drill.exec.store.dfs.FileSystemPlugin;
import org.apache.drill.exec.store.dfs.FormatMatcher;
import org.apache.drill.exec.store.dfs.FormatPlugin;
import org.apache.drill.exec.store.dfs.FormatSelection;
import org.apache.drill.exec.store.plan.rel.PluginDrillTable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;

public class DeltaFormatMatcher
extends FormatMatcher {
    private final DeltaFormatPlugin formatPlugin;

    public DeltaFormatMatcher(DeltaFormatPlugin formatPlugin) {
        this.formatPlugin = formatPlugin;
    }

    public boolean supportDirectoryReads() {
        return true;
    }

    public DrillTable isReadable(DrillFileSystem fs, FileSelection selection, FileSystemPlugin fsPlugin, String storageEngineName, SchemaConfig schemaConfig) {
        if (DeltaLog.forTable((Configuration)fsPlugin.getFsConf(), (Path)selection.getSelectionRoot()).tableExists()) {
            FormatSelection formatSelection = new FormatSelection((FormatPluginConfig)this.formatPlugin.getConfig(), selection);
            return new PluginDrillTable((StoragePlugin)fsPlugin, storageEngineName, schemaConfig.getUserName(), (DrillTableSelection)formatSelection, this.formatPlugin.getConvention());
        }
        return null;
    }

    public boolean isFileReadable(DrillFileSystem fs, FileStatus status) {
        return false;
    }

    public FormatPlugin getFormatPlugin() {
        return this.formatPlugin;
    }

    public int priority() {
        return 7;
    }
}

