/*
 * Decompiled with CFR 0.152.
 */
package com.github.pjfanning.poi.xssf.streaming;

import com.github.pjfanning.poi.xssf.streaming.Constants;
import com.github.pjfanning.poi.xssf.streaming.TextParser;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentMap;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.poi.ooxml.POIXMLException;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.xssf.model.SharedStringsTable;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlOptions;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTRst;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTSst;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.SstDocument;
import org.slf4j.Logger;

public abstract class SharedStringsTableBase
extends SharedStringsTable {
    private static final QName COUNT_QNAME = new QName("count");
    private static final QName UNIQUE_COUNT_QNAME = new QName("uniqueCount");
    protected final boolean fullFormat;
    protected ConcurrentMap<Integer, String> strings;
    protected ConcurrentMap<String, Integer> stmap;
    private static final XmlOptions siSaveOptions = new XmlOptions(Constants.saveOptions);

    protected SharedStringsTableBase(boolean fullFormat) {
        this.fullFormat = fullFormat;
    }

    protected abstract Logger getLogger();

    protected abstract Iterator<Integer> keyIterator();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void readFrom(InputStream is) throws IOException {
        try {
            int uniqueCount = -1;
            int count = -1;
            try (XMLEventReader xmlEventReader = Constants.XML_INPUT_FACTORY.createXMLEventReader(is);){
                while (xmlEventReader.hasNext()) {
                    XMLEvent xmlEvent = xmlEventReader.nextEvent();
                    if (!xmlEvent.isStartElement()) continue;
                    StartElement startElement = xmlEvent.asStartElement();
                    QName startTag = startElement.getName();
                    String localPart = startTag.getLocalPart();
                    if (localPart.equals("sst")) {
                        try {
                            Attribute countAtt = startElement.getAttributeByName(COUNT_QNAME);
                            if (countAtt != null) {
                                count = Integer.parseInt(countAtt.getValue());
                            }
                        }
                        catch (Exception e) {
                            this.getLogger().warn("Failed to parse SharedStringsTable count");
                        }
                        try {
                            Attribute uniqueCountAtt = startElement.getAttributeByName(UNIQUE_COUNT_QNAME);
                            if (uniqueCountAtt == null) continue;
                            uniqueCount = Integer.parseInt(uniqueCountAtt.getValue());
                            continue;
                        }
                        catch (Exception e) {
                            this.getLogger().warn("Failed to parse SharedStringsTable uniqueCount");
                            continue;
                        }
                    }
                    if (!localPart.equals("si")) continue;
                    if (this.fullFormat) {
                        CTSst sst;
                        List<String> tags = Arrays.asList("sst", "si");
                        String text = TextParser.getXMLText(xmlEventReader, startTag, tags);
                        try {
                            sst = ((SstDocument)SstDocument.Factory.parse(text)).getSst();
                        }
                        catch (XmlException e) {
                            throw new IOException("Failed to parse shared string text", e);
                        }
                        this.addRSTEntry(new XSSFRichTextString(sst.getSiArray(0)).getCTRst(), true);
                        continue;
                    }
                    String text = TextParser.parseCT_Rst(xmlEventReader);
                    this.addPlainStringEntry(text, true);
                }
                if (count > -1) {
                    this.count = count;
                }
                if (uniqueCount <= -1) return;
                if (uniqueCount != this.uniqueCount) {
                    this.getLogger().warn("SharedStringsTable has uniqueCount={} but read {} entries. This will probably cause some cells to be misinterpreted.", (Object)uniqueCount, (Object)this.uniqueCount);
                }
                this.uniqueCount = uniqueCount;
                return;
            }
        }
        catch (XMLStreamException e) {
            throw new IOException("Failed to parse shared strings", e);
        }
    }

    private CTRst getRSTEntryAt(int idx) throws XmlException, IOException {
        String str = (String)this.strings.get(idx);
        if (str == null) {
            throw new NoSuchElementException();
        }
        return (CTRst)CTRst.Factory.parse((Reader)new StringReader(str));
    }

    private String getPlainStringEntryAt(int idx) {
        String str = (String)this.strings.get(idx);
        if (str == null) {
            throw new NoSuchElementException();
        }
        return str;
    }

    public RichTextString getItemAt(int idx) throws POIXMLException {
        try {
            if (this.fullFormat) {
                return new XSSFRichTextString(this.getRSTEntryAt(idx));
            }
            return new XSSFRichTextString(this.getPlainStringEntryAt(idx));
        }
        catch (NoSuchElementException nsee) {
            throw nsee;
        }
        catch (Exception e) {
            throw new POIXMLException("Failed to parse shared string", (Throwable)e);
        }
    }

    public String getString(int idx) throws POIXMLException {
        if (this.fullFormat) {
            return this.getItemAt(idx).getString();
        }
        return this.getPlainStringEntryAt(idx);
    }

    public int getCount() {
        return this.count;
    }

    public int getUniqueCount() {
        return this.uniqueCount;
    }

    private int addRSTEntry(CTRst st, boolean keepDuplicates) {
        if (st == null) {
            throw new NullPointerException("Cannot add null entry to SharedStringsTable");
        }
        String s = this.xmlText(st);
        ++this.count;
        if (!keepDuplicates && this.stmap.containsKey(s)) {
            return (Integer)this.stmap.get(s);
        }
        int idx = this.uniqueCount++;
        this.stmap.put(s, idx);
        this.strings.put(idx, st.xmlText());
        return idx;
    }

    private int addPlainStringEntry(String string, boolean keepDuplicates) {
        if (string == null) {
            throw new NullPointerException("Cannot add null entry to SharedStringsTable");
        }
        ++this.count;
        if (!keepDuplicates && this.stmap.containsKey(string)) {
            return (Integer)this.stmap.get(string);
        }
        int idx = this.uniqueCount++;
        this.stmap.put(string, idx);
        this.strings.put(idx, string);
        return idx;
    }

    public int addSharedStringItem(RichTextString string) {
        if (!(string instanceof XSSFRichTextString)) {
            throw new IllegalArgumentException("Only XSSFRichTextString argument is supported");
        }
        if (this.fullFormat) {
            return this.addRSTEntry(((XSSFRichTextString)string).getCTRst(), false);
        }
        return this.addPlainStringEntry(string.getString(), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(OutputStream out) throws IOException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out, StandardCharsets.UTF_8));
        try {
            writer.write("<sst count=\"");
            writer.write(Integer.toString(this.count));
            writer.write("\" uniqueCount=\"");
            writer.write(Integer.toString(this.uniqueCount));
            writer.write("\" xmlns=\"");
            writer.write("http://schemas.openxmlformats.org/spreadsheetml/2006/main");
            writer.write("\">");
            Iterator<Integer> idIter = this.keyIterator();
            while (idIter.hasNext()) {
                Integer stringId = idIter.next();
                XSSFRichTextString rst = (XSSFRichTextString)this.getItemAt(stringId);
                if (rst == null) continue;
                writer.write(rst.getCTRst().xmlText(siSaveOptions));
            }
            writer.write("</sst>");
        }
        finally {
            ((Writer)writer).flush();
        }
    }

    static {
        siSaveOptions.setSaveSyntheticDocumentElement(new QName("http://schemas.openxmlformats.org/spreadsheetml/2006/main", "si"));
    }
}

