/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.data.impl.builder;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import org.apache.deltaspike.data.api.QueryResult;
import org.apache.deltaspike.data.impl.builder.AnnotatedQueryBuilder;
import org.apache.deltaspike.data.impl.builder.DelegateQueryBuilder;
import org.apache.deltaspike.data.impl.builder.MethodQueryBuilder;
import org.apache.deltaspike.data.impl.builder.QueryBuilder;
import org.apache.deltaspike.data.impl.builder.WrappedQueryBuilder;
import org.apache.deltaspike.data.impl.handler.CdiQueryInvocationContext;
import org.apache.deltaspike.data.impl.meta.RepositoryMethodMetadata;
import org.apache.deltaspike.data.impl.meta.RepositoryMethodType;

@ApplicationScoped
public class QueryBuilderFactory {
    @Inject
    private MethodQueryBuilder methodQueryBuilder;
    @Inject
    private DelegateQueryBuilder delegateQueryBuilder;
    @Inject
    private AnnotatedQueryBuilder annotatedQueryBuilder;

    protected QueryBuilder getQueryBuilder(RepositoryMethodType repositoryMethodType) {
        switch (repositoryMethodType) {
            case ANNOTATED: {
                return this.annotatedQueryBuilder;
            }
            case PARSE: {
                return this.methodQueryBuilder;
            }
            case DELEGATE: {
                return this.delegateQueryBuilder;
            }
        }
        throw new RuntimeException("No " + QueryBuilder.class.getName() + " avialable for type: " + repositoryMethodType);
    }

    public QueryBuilder build(RepositoryMethodMetadata methodMetadata, CdiQueryInvocationContext context) {
        QueryBuilder builder = this.getQueryBuilder(context.getRepositoryMethodMetadata().getMethodType());
        if (QueryResult.class.equals(methodMetadata.getMethod().getReturnType())) {
            return new WrappedQueryBuilder(builder);
        }
        return builder;
    }
}

