/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.cdise.weld;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.ConversationScoped;
import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.context.RequestScoped;
import jakarta.enterprise.context.SessionScoped;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import org.apache.deltaspike.cdise.api.ContextControl;
import org.jboss.weld.context.ApplicationContext;
import org.jboss.weld.context.bound.BoundConversationContext;
import org.jboss.weld.context.bound.BoundRequestContext;
import org.jboss.weld.context.bound.BoundSessionContext;
import org.jboss.weld.context.bound.MutableBoundRequest;

@Dependent
public class WeldContextControl
implements ContextControl {
    private static ThreadLocal<RequestContextHolder> requestContexts = new ThreadLocal();
    private static ThreadLocal<Map<String, Object>> sessionMaps = new ThreadLocal();
    @Inject
    private ApplicationContext applicationContext;
    @Inject
    private BoundSessionContext sessionContext;
    @Inject
    private Instance<BoundRequestContext> requestContextFactory;
    @Inject
    private BoundConversationContext conversationContext;

    public void startContexts() {
        this.startApplicationScope();
        this.startSessionScope();
        this.startRequestScope();
        this.startConversationScope(null);
    }

    public void startContext(Class<? extends Annotation> scopeClass) {
        if (scopeClass.isAssignableFrom(ApplicationScoped.class)) {
            this.startApplicationScope();
        } else if (scopeClass.isAssignableFrom(SessionScoped.class)) {
            this.startSessionScope();
        } else if (scopeClass.isAssignableFrom(RequestScoped.class)) {
            this.startRequestScope();
        } else if (scopeClass.isAssignableFrom(ConversationScoped.class)) {
            this.startConversationScope(null);
        }
    }

    public void stopContexts() {
        this.stopConversationScope();
        this.stopRequestScope();
        this.stopSessionScope();
        this.stopApplicationScope();
    }

    public void stopContext(Class<? extends Annotation> scopeClass) {
        if (scopeClass.isAssignableFrom(ApplicationScoped.class)) {
            this.stopApplicationScope();
        } else if (scopeClass.isAssignableFrom(SessionScoped.class)) {
            this.stopSessionScope();
        } else if (scopeClass.isAssignableFrom(RequestScoped.class)) {
            this.stopRequestScope();
        } else if (scopeClass.isAssignableFrom(ConversationScoped.class)) {
            this.stopConversationScope();
        }
    }

    private void startApplicationScope() {
    }

    private void stopApplicationScope() {
        if (this.applicationContext.isActive()) {
            this.applicationContext.invalidate();
        }
    }

    void startRequestScope() {
        RequestContextHolder rcHolder = requestContexts.get();
        if (rcHolder == null) {
            rcHolder = new RequestContextHolder((BoundRequestContext)this.requestContextFactory.get(), new HashMap<String, Object>());
            requestContexts.set(rcHolder);
            rcHolder.getBoundRequestContext().associate(rcHolder.getRequestMap());
            rcHolder.getBoundRequestContext().activate();
        }
    }

    void stopRequestScope() {
        RequestContextHolder rcHolder = requestContexts.get();
        if (rcHolder != null && rcHolder.getBoundRequestContext().isActive()) {
            rcHolder.getBoundRequestContext().invalidate();
            rcHolder.getBoundRequestContext().deactivate();
            rcHolder.getBoundRequestContext().dissociate(rcHolder.getRequestMap());
            requestContexts.set(null);
            requestContexts.remove();
        }
    }

    private void startSessionScope() {
        Map<String, Object> sessionMap = sessionMaps.get();
        if (sessionMap == null) {
            sessionMap = new HashMap<String, Object>();
            sessionMaps.set(sessionMap);
        }
        this.sessionContext.associate(sessionMap);
        this.sessionContext.activate();
    }

    private void stopSessionScope() {
        if (this.sessionContext.isActive()) {
            this.sessionContext.invalidate();
            this.sessionContext.deactivate();
            this.sessionContext.dissociate(sessionMaps.get());
            sessionMaps.set(null);
            sessionMaps.remove();
        }
    }

    void startConversationScope(String cid) {
        RequestContextHolder rcHolder = requestContexts.get();
        if (rcHolder == null) {
            this.startRequestScope();
            rcHolder = requestContexts.get();
        }
        this.conversationContext.associate((Object)new MutableBoundRequest(rcHolder.requestMap, sessionMaps.get()));
        this.conversationContext.activate(cid);
    }

    void stopConversationScope() {
        RequestContextHolder rcHolder = requestContexts.get();
        if (rcHolder == null) {
            this.startRequestScope();
            rcHolder = requestContexts.get();
        }
        if (this.conversationContext.isActive()) {
            this.conversationContext.invalidate();
            this.conversationContext.deactivate();
            this.conversationContext.dissociate((Object)new MutableBoundRequest(rcHolder.getRequestMap(), sessionMaps.get()));
        }
    }

    private static class RequestContextHolder {
        private final BoundRequestContext boundRequestContext;
        private final Map<String, Object> requestMap;

        private RequestContextHolder(BoundRequestContext boundRequestContext, Map<String, Object> requestMap) {
            this.boundRequestContext = boundRequestContext;
            this.requestMap = requestMap;
        }

        public BoundRequestContext getBoundRequestContext() {
            return this.boundRequestContext;
        }

        public Map<String, Object> getRequestMap() {
            return this.requestMap;
        }
    }
}

