/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.sql;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.torque.Column;
import org.apache.torque.TorqueException;
import org.apache.torque.criteria.FromElement;
import org.apache.torque.util.ColumnValues;
import org.apache.torque.util.JdbcTypedValue;
import org.apache.torque.util.UniqueList;

public class Query {
    private static final String SELECT = "SELECT ";
    private static final String UPDATE = "UPDATE ";
    private static final String DELETE_FROM = "DELETE FROM ";
    private static final String FROM = " FROM ";
    private static final String SET = " SET ";
    private static final String WHERE = " WHERE ";
    private static final String AND = " AND ";
    private static final String ORDER_BY = " ORDER BY ";
    private static final String GROUP_BY = " GROUP BY ";
    private static final String HAVING = " HAVING ";
    private static final String LIMIT = " LIMIT ";
    private static final String OFFSET = " OFFSET ";
    private static final String SET_ROWCOUNT = " SET ROWCOUNT ";
    private final UniqueList<String> selectModifiers = new UniqueList();
    private final UniqueList<String> columns = new UniqueList();
    private final ColumnValues updateValues = new ColumnValues();
    private final UniqueList<FromElement> fromClause = new UniqueList();
    private final UniqueList<String> whereClause = new UniqueList();
    private final List<Object> whereClausePreparedStatementReplacements = new ArrayList<Object>();
    private final UniqueList<String> orderByColumns = new UniqueList();
    private final UniqueList<String> groupByColumns = new UniqueList();
    private String having;
    private String limit;
    private String preLimit;
    private String postLimit;
    private String offset;
    private String rowcount;
    private String forUpdate;
    private Type type = Type.SELECT;
    private Integer fetchSize;
    private final List<Query> parts = new ArrayList<Query>();
    private String partOperator;

    public UniqueList<String> getSelectModifiers() {
        return this.selectModifiers;
    }

    public UniqueList<String> getSelectClause() {
        return this.columns;
    }

    public ColumnValues getUpdateValues() {
        return this.updateValues;
    }

    public UniqueList<FromElement> getFromClause() {
        return this.fromClause;
    }

    public UniqueList<String> getWhereClause() {
        return this.whereClause;
    }

    public List<Object> getWhereClausePreparedStatementReplacements() {
        return this.whereClausePreparedStatementReplacements;
    }

    public List<Object> getPreparedStatementReplacements() {
        ArrayList<Object> result = new ArrayList<Object>();
        for (FromElement fromElement : this.fromClause) {
            result.addAll(fromElement.getPreparedStatementReplacements());
        }
        for (Query part : this.parts) {
            result.addAll(part.getPreparedStatementReplacements());
        }
        result.addAll(this.whereClausePreparedStatementReplacements);
        return Collections.unmodifiableList(result);
    }

    public UniqueList<String> getOrderByClause() {
        return this.orderByColumns;
    }

    public UniqueList<String> getGroupByClause() {
        return this.groupByColumns;
    }

    public String getHaving() {
        return this.having;
    }

    public void setHaving(String having) {
        this.having = having;
    }

    public String getLimit() {
        return this.limit;
    }

    public void setLimit(String limit) {
        this.limit = limit;
    }

    public String getPreLimit() {
        return this.preLimit;
    }

    public void setPreLimit(String preLimit) {
        this.preLimit = preLimit;
    }

    public String getPostLimit() {
        return this.postLimit;
    }

    public void setPostLimit(String postLimit) {
        this.postLimit = postLimit;
    }

    public String getOffset() {
        return this.offset;
    }

    public void setOffset(String offset) {
        this.offset = offset;
    }

    public String getRowcount() {
        return this.rowcount;
    }

    public void setRowcount(String rowcount) {
        this.rowcount = rowcount;
    }

    public void setForUpdate(String forUpdate) {
        this.forUpdate = forUpdate;
    }

    public String getForUpdate() {
        return this.forUpdate;
    }

    public boolean hasLimit() {
        return this.preLimit != null || this.postLimit != null || this.limit != null;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        if (type == null) {
            throw new NullPointerException("type is null");
        }
        this.type = type;
    }

    public Integer getFetchSize() {
        return this.fetchSize;
    }

    public void setFetchSize(Integer fetchSize) {
        this.fetchSize = fetchSize;
    }

    public List<Query> getParts() {
        return this.parts;
    }

    public String getPartOperator() {
        return this.partOperator;
    }

    public void setPartOperator(String partOperator) {
        this.partOperator = partOperator;
    }

    public String toString() {
        return this.toStringBuilder(new StringBuilder()).toString();
    }

    public StringBuilder toStringBuilder(StringBuilder stringBuilder) {
        if (this.preLimit != null) {
            stringBuilder.append(this.preLimit);
        }
        if (this.rowcount != null) {
            stringBuilder.append(SET_ROWCOUNT).append(this.rowcount).append(" ");
        }
        if (this.parts.isEmpty()) {
            if (Type.SELECT == this.type) {
                stringBuilder.append(SELECT).append(StringUtils.join(this.selectModifiers.iterator(), (String)" ")).append(StringUtils.join(this.columns.iterator(), (String)", ")).append(FROM);
            } else if (Type.UPDATE == this.type) {
                stringBuilder.append(UPDATE);
            } else if (Type.DELETE == this.type) {
                stringBuilder.append(DELETE_FROM);
            }
            boolean first = true;
            for (FromElement fromElement : this.fromClause) {
                if (!first && fromElement.getJoinCondition() == null) {
                    stringBuilder.append(", ");
                }
                first = false;
                stringBuilder.append(fromElement.toString());
            }
            if (Type.SELECT == this.type && this.forUpdate != null && !"FOR UPDATE".equals(this.forUpdate)) {
                stringBuilder.append(" ").append(this.forUpdate);
            }
            if (Type.UPDATE == this.type) {
                stringBuilder.append(SET);
                first = true;
                for (Map.Entry<Column, JdbcTypedValue> entry : this.updateValues.entrySet()) {
                    Column column;
                    String columnName;
                    if (!first) {
                        stringBuilder.append(",");
                    }
                    if ((columnName = (column = entry.getKey()).getColumnName()) == null) {
                        columnName = column.getSqlExpression();
                    }
                    stringBuilder.append(columnName);
                    if (entry.getValue().getSqlExpression() == null) {
                        stringBuilder.append("=?");
                    } else {
                        Column sqlExpression = entry.getValue().getSqlExpression();
                        stringBuilder.append("=").append(sqlExpression.getSqlExpression());
                    }
                    first = false;
                }
            }
            if (!this.whereClause.isEmpty()) {
                stringBuilder.append(WHERE).append(StringUtils.join(this.whereClause.iterator(), (String)AND));
            }
            if (!this.groupByColumns.isEmpty()) {
                stringBuilder.append(GROUP_BY).append(StringUtils.join(this.groupByColumns.iterator(), (String)", "));
            }
            if (this.having != null) {
                stringBuilder.append(HAVING).append(this.having);
            }
        } else {
            boolean first = true;
            for (Query part : this.parts) {
                if (!first) {
                    stringBuilder.append(this.partOperator);
                }
                stringBuilder.append('(');
                part.toStringBuilder(stringBuilder);
                stringBuilder.append(')');
                first = false;
            }
        }
        if (!this.orderByColumns.isEmpty()) {
            stringBuilder.append(ORDER_BY).append(StringUtils.join(this.orderByColumns.iterator(), (String)", "));
        }
        if (this.limit != null) {
            stringBuilder.append(LIMIT).append(this.limit);
        }
        if (this.offset != null) {
            stringBuilder.append(OFFSET).append(this.offset);
        }
        if (this.rowcount != null) {
            stringBuilder.append(SET_ROWCOUNT).append("0");
        }
        if (this.postLimit != null) {
            stringBuilder.append(this.postLimit);
        }
        if (Type.SELECT == this.type && this.forUpdate != null && "FOR UPDATE".equals(this.forUpdate)) {
            stringBuilder.append(" ").append(this.forUpdate);
        }
        return stringBuilder;
    }

    public String getDisplayString() throws TorqueException {
        StringBuilder stringBuilder = new StringBuilder();
        this.toStringBuilder(stringBuilder);
        stringBuilder.append(" Replacements: [");
        boolean first = true;
        for (Object replacement : this.getPreparedStatementReplacements()) {
            if (!first) {
                stringBuilder.append(",");
            }
            stringBuilder.append(replacement);
            first = false;
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public static enum Type {
        SELECT,
        UPDATE,
        DELETE;

    }
}

