/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.sql;

import java.io.Serializable;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.torque.Column;
import org.apache.torque.criteria.SqlEnum;

public class OrderBy
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Column column;
    private SqlEnum order;
    private boolean ignoreCase = true;

    public OrderBy(Column column, SqlEnum order, boolean ignoreCase) {
        if (column == null) {
            throw new NullPointerException("column is null");
        }
        if (order == null) {
            throw new NullPointerException("order is null");
        }
        if (SqlEnum.DESC != order && SqlEnum.ASC != order) {
            throw new IllegalArgumentException("unknown order: " + order);
        }
        this.column = column;
        this.order = order;
        this.ignoreCase = ignoreCase;
    }

    public Column getColumn() {
        return this.column;
    }

    public SqlEnum getOrder() {
        return this.order;
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.column.getSqlExpression()).append((Object)this.column.getSchemaName()).append((Object)this.column.getTableName()).append((Object)this.column.getColumnName()).append((Object)this.order).append(this.ignoreCase).toHashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OrderBy other = (OrderBy)obj;
        return new EqualsBuilder().append((Object)this.column.getSqlExpression(), (Object)other.column.getSqlExpression()).append((Object)this.column.getSchemaName(), (Object)other.column.getSchemaName()).append((Object)this.column.getTableName(), (Object)other.column.getTableName()).append((Object)this.column.getColumnName(), (Object)other.column.getColumnName()).append((Object)this.order, (Object)other.order).append(this.ignoreCase, other.ignoreCase).isEquals();
    }
}

