/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.generator.configuration.outlet;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.generator.configuration.ConfigurationException;
import org.apache.torque.generator.configuration.ConfigurationHandlers;
import org.apache.torque.generator.configuration.ConfigurationProvider;
import org.apache.torque.generator.configuration.UnitDescriptor;
import org.apache.torque.generator.configuration.mergepoint.MergepointMapping;
import org.apache.torque.generator.configuration.outlet.OutletConfiguration;
import org.apache.torque.generator.configuration.outlet.OutletConfigurationSaxHandler;
import org.apache.torque.generator.configuration.paths.ProjectPaths;
import org.apache.torque.generator.outlet.Outlet;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class OutletConfigurationXmlParser {
    private static SAXParserFactory saxFactory;
    private static Log log;

    public OutletConfiguration readOutletConfiguration(ConfigurationProvider configurationProvider, ConfigurationHandlers configurationHandlers, UnitDescriptor unitDescriptor) throws ConfigurationException {
        if (configurationHandlers == null) {
            log.error((Object)"OutletConfiguration:  configurationHandlers is null");
            throw new NullPointerException("configurationHandlers is null");
        }
        if (configurationProvider == null) {
            log.error((Object)"OutletConfiguration:  configurationProvider is null");
            throw new NullPointerException("configurationProvider is null");
        }
        ArrayList<Outlet> allOutlets = new ArrayList<Outlet>();
        ArrayList<MergepointMapping> allMergepointMappings = new ArrayList<MergepointMapping>();
        Collection<String> outletConfigNames = configurationProvider.getOutletConfigurationNames();
        for (String outletConfigName : outletConfigNames) {
            InputStream inputStream = null;
            try {
                inputStream = configurationProvider.getOutletConfigurationInputStream(outletConfigName);
                OutletConfigFileContent fileContent = this.readOutletConfig(inputStream, configurationProvider, unitDescriptor.getProjectPaths(), configurationHandlers);
                allOutlets.addAll(fileContent.getOutlets());
                allMergepointMappings.addAll(fileContent.getMergepointMappings());
            }
            catch (SAXParseException e) {
                throw new ConfigurationException("Error parsing outlet configuration " + outletConfigName + " at line " + e.getLineNumber() + " column " + e.getColumnNumber() + " : " + e.getMessage(), e);
            }
            catch (Exception e) {
                throw new ConfigurationException("Error parsing outlet configuration " + outletConfigName, e);
            }
            finally {
                if (inputStream == null) continue;
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    log.warn((Object)("Could not close outletConfigurationInputStream " + outletConfigName), (Throwable)e);
                }
            }
        }
        return new OutletConfiguration(allOutlets, allMergepointMappings, unitDescriptor);
    }

    private OutletConfigFileContent readOutletConfig(InputStream outletConfigurationInputStream, ConfigurationProvider configurationProvider, ProjectPaths projectPaths, ConfigurationHandlers configurationHandlers) throws SAXException, IOException, ParserConfigurationException {
        SAXParser parser = saxFactory.newSAXParser();
        OutletConfigurationSaxHandler saxHandler = new OutletConfigurationSaxHandler(configurationProvider, projectPaths, configurationHandlers);
        InputSource is = new InputSource(outletConfigurationInputStream);
        parser.parse(is, (DefaultHandler)saxHandler);
        return new OutletConfigFileContent(saxHandler.getOutlets(), saxHandler.getMergepointMappings());
    }

    static {
        log = LogFactory.getLog(OutletConfigurationXmlParser.class);
        saxFactory = SAXParserFactory.newInstance();
        saxFactory.setNamespaceAware(true);
        try {
            saxFactory.setFeature("http://xml.org/sax/features/validation", true);
            saxFactory.setFeature("http://apache.org/xml/features/validation/schema", true);
        }
        catch (SAXNotSupportedException e) {
            throw new RuntimeException(e);
        }
        catch (SAXNotRecognizedException e) {
            throw new RuntimeException(e);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class OutletConfigFileContent {
        private final List<Outlet> outlets;
        private final List<MergepointMapping> mergepointMappings;

        public OutletConfigFileContent(List<Outlet> outlets, List<MergepointMapping> mergepointMappings) {
            this.outlets = outlets;
            this.mergepointMappings = mergepointMappings;
        }

        public List<Outlet> getOutlets() {
            return this.outlets;
        }

        public List<MergepointMapping> getMergepointMappings() {
            return this.mergepointMappings;
        }
    }
}

