/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.generator.configuration;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ConfigurationEntityResolver
implements EntityResolver {
    public static final String CONFIGURATION_SCHEMA_SYSTEMID = "http://db.apache.org/torque/4.0/generator/configuration.xsd";
    public static final String OUTLET_SCHEMA_SYSTEMID = "http://db.apache.org/torque/4.0/generator/outlet.xsd";
    private static Log log = LogFactory.getLog(ConfigurationEntityResolver.class);
    private static final Class<ConfigurationEntityResolver> CLAZZ = ConfigurationEntityResolver.class;

    public InputSource resolveEntity(String publicId, String systemId) throws IOException, SAXException {
        if (CONFIGURATION_SCHEMA_SYSTEMID.equals(systemId)) {
            return this.readFromClasspath("configuration.xsd");
        }
        if (OUTLET_SCHEMA_SYSTEMID.equals(systemId)) {
            return this.readFromClasspath("outlet.xsd");
        }
        log.debug((Object)"Resolver: used default behaviour");
        return null;
    }

    private InputSource readFromClasspath(String resourceName) throws SAXException {
        try {
            InputStream inputStream = CLAZZ.getResourceAsStream(resourceName);
            if (inputStream != null) {
                String pkg = CLAZZ.getName().substring(0, CLAZZ.getName().lastIndexOf(46));
                log.debug((Object)("Resolver: used " + resourceName + " from '" + pkg + "' package"));
                return new InputSource(inputStream);
            }
            log.warn((Object)"Could not locate resource");
            return null;
        }
        catch (Exception ex) {
            throw new SAXException("Could not get stream for " + resourceName, ex);
        }
    }
}

