/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.theta;

import org.apache.datasketches.theta.AnotB;
import org.apache.datasketches.theta.CompactSketch;
import org.apache.datasketches.theta.Intersection;
import org.apache.datasketches.theta.SetOperation;
import org.apache.datasketches.theta.Sketch;
import org.apache.datasketches.theta.Union;
import org.apache.datasketches.theta.UpdateSketch;
import org.apache.datasketches.theta.UpdateSketchBuilder;
import org.testng.annotations.Test;

public class ExamplesTest {
    @Test
    public void simpleCountingSketch() {
        int k = 4096;
        int u = 1000000;
        UpdateSketch sketch = UpdateSketch.builder().setNominalEntries(4096).build();
        for (int i = 0; i < 1000000; ++i) {
            sketch.update((long)i);
        }
        ExamplesTest.println(sketch.toString());
    }

    @Test
    public void theta2dot0Examples() {
        UpdateSketchBuilder bldr = UpdateSketch.builder();
        UpdateSketch skA = bldr.build();
        UpdateSketch skB = bldr.build();
        for (int i = 1; i <= 1000; ++i) {
            skA.update((long)i);
            skB.update((long)(i + 250));
        }
        Union union = SetOperation.builder().buildUnion();
        CompactSketch csk = union.union((Sketch)skA, (Sketch)skB);
        assert (csk.getEstimate() == 1250.0);
        union = SetOperation.builder().buildUnion();
        union.union((Sketch)skA);
        union.union((Sketch)skB);
        csk = union.getResult();
        assert (csk.getEstimate() == 1250.0);
        Intersection inter = SetOperation.builder().buildIntersection();
        csk = inter.intersect((Sketch)skA, (Sketch)skB);
        assert (csk.getEstimate() == 750.0);
        inter = SetOperation.builder().buildIntersection();
        inter.intersect((Sketch)skA);
        inter.intersect((Sketch)skB);
        csk = inter.getResult();
        assert (csk.getEstimate() == 750.0);
        AnotB diff = SetOperation.builder().buildANotB();
        csk = diff.aNotB((Sketch)skA, (Sketch)skB);
        assert (csk.getEstimate() == 250.0);
        diff = SetOperation.builder().buildANotB();
        diff.setA((Sketch)skA);
        diff.notB((Sketch)skB);
        csk = diff.getResult(true);
        assert (csk.getEstimate() == 250.0);
    }

    @Test
    public void printlnTest() {
        ExamplesTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
    }
}

