/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.api.validation;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.daffodil.api.validation.ValidatorFactory;
import org.apache.daffodil.api.validation.ValidatorNotRegisteredException;
import org.apache.daffodil.lib.util.SimpleNamedServiceLoader;

public class Validators {
    private static final Map<String, ValidatorFactory> impls = SimpleNamedServiceLoader.loadClass(ValidatorFactory.class);

    private Validators() {
    }

    public static ValidatorFactory get(String string) throws ValidatorNotRegisteredException {
        if (Validators.isRegistered(string)) {
            return impls.get(string);
        }
        throw new ValidatorNotRegisteredException(string);
    }

    public static ValidatorFactory find(String string) {
        return impls.get(string);
    }

    public static boolean isRegistered(String string) {
        return impls.containsKey(string);
    }

    public static List<String> list() {
        return new ArrayList<String>(impls.keySet());
    }
}

