/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.layers.runtime1;

import java.io.OutputStream;
import java.util.ArrayDeque;
import java.util.Deque;
import org.apache.daffodil.layers.runtime1.ByteSwap;
import org.apache.daffodil.lib.exceptions.Assert$;
import scala.Byte$;
import scala.runtime.BoxesRunTime;

public class ByteSwapOutputStream
extends OutputStream {
    private final ByteSwap layer;
    private final int wordsize;
    private final OutputStream jos;
    private final boolean wholeWords;
    private final Deque<Object> stack;
    private boolean closed;

    public ByteSwapOutputStream(ByteSwap layer, int wordsize, OutputStream jos, boolean wholeWords) {
        this.layer = layer;
        this.wordsize = wordsize;
        this.jos = jos;
        this.wholeWords = wholeWords;
        this.stack = new ArrayDeque<Object>(wordsize);
        this.closed = false;
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.closed = true;
            if (this.wholeWords && this.stack.size() % this.wordsize != 0) {
                this.layer.processingError(this.layer.notWordSize());
            }
            while (!this.stack.isEmpty()) {
                this.jos.write(Byte$.MODULE$.byte2int(BoxesRunTime.unboxToByte((Object)this.stack.pop())));
            }
            this.jos.close();
            return;
        }
    }

    @Override
    public void write(int bInt) {
        if (this.closed) {
            throw Assert$.MODULE$.usageError("ByteSwapOutputStream.this.closed.unary_!");
        }
        this.stack.push(BoxesRunTime.boxToByte((byte)((byte)bInt)));
        if (this.stack.size() == this.wordsize) {
            while (!this.stack.isEmpty()) {
                this.jos.write(Byte$.MODULE$.byte2int(BoxesRunTime.unboxToByte((Object)this.stack.pop())));
            }
            return;
        }
    }
}

