/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.encoding;

import io.undertow.predicate.Predicate;
import io.undertow.predicate.Predicates;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.encoding.AllowedContentEncodings;
import io.undertow.server.handlers.encoding.ContentEncodingProvider;
import io.undertow.server.handlers.encoding.EncodingMapping;
import io.undertow.util.CopyOnWriteMap;
import io.undertow.util.HeaderValues;
import io.undertow.util.Headers;
import io.undertow.util.QValueParser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class ContentEncodingRepository {
    public static final String IDENTITY = "identity";
    public static final EncodingMapping IDENTITY_ENCODING = new EncodingMapping("identity", ContentEncodingProvider.IDENTITY, 0, Predicates.truePredicate());
    private final Map<String, EncodingMapping> encodingMap = new CopyOnWriteMap<String, EncodingMapping>();

    public AllowedContentEncodings getContentEncodings(HttpServerExchange exchange) {
        HeaderValues res = exchange.getRequestHeaders().get(Headers.ACCEPT_ENCODING);
        if (res == null || res.isEmpty()) {
            return null;
        }
        ArrayList<EncodingMapping> resultingMappings = new ArrayList<EncodingMapping>();
        List<List<QValueParser.QValueResult>> found = QValueParser.parse(res);
        for (int i = 0; i < found.size(); ++i) {
            List<QValueParser.QValueResult> result = found.get(i);
            ArrayList<EncodingMapping> available = new ArrayList<EncodingMapping>();
            boolean includesIdentity = false;
            boolean isQValue0 = false;
            for (int j = 0; j < result.size(); ++j) {
                EncodingMapping encoding;
                QValueParser.QValueResult value = result.get(j);
                if (value.getValue().equals("*")) {
                    includesIdentity = true;
                    encoding = IDENTITY_ENCODING;
                } else {
                    encoding = this.encodingMap.get(value.getValue());
                    if (encoding == null && IDENTITY.equals(value.getValue())) {
                        encoding = IDENTITY_ENCODING;
                    }
                }
                if (value.isQValueZero()) {
                    isQValue0 = true;
                }
                if (encoding == null) continue;
                available.add(encoding);
            }
            if (isQValue0) {
                if (!resultingMappings.isEmpty()) continue;
                if (includesIdentity) {
                    return new AllowedContentEncodings(exchange, Collections.emptyList());
                }
                return null;
            }
            if (available.isEmpty()) continue;
            Collections.sort(available, Collections.reverseOrder());
            resultingMappings.addAll(available);
        }
        if (!resultingMappings.isEmpty()) {
            return new AllowedContentEncodings(exchange, resultingMappings);
        }
        return null;
    }

    public synchronized ContentEncodingRepository addEncodingHandler(String encoding, ContentEncodingProvider encoder, int priority) {
        this.addEncodingHandler(encoding, encoder, priority, Predicates.truePredicate());
        return this;
    }

    public synchronized ContentEncodingRepository addEncodingHandler(String encoding, ContentEncodingProvider encoder, int priority, Predicate enabledPredicate) {
        this.encodingMap.put(encoding, new EncodingMapping(encoding, encoder, priority, enabledPredicate));
        return this;
    }

    public synchronized ContentEncodingRepository removeEncodingHandler(String encoding) {
        this.encodingMap.remove(encoding);
        return this;
    }
}

