/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl.wireformat;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.transaction.xa.Xid;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.core.protocol.core.impl.PacketImpl;
import org.apache.activemq.artemis.utils.XidCodecSupport;

public class SessionXAGetInDoubtXidsResponseMessage
extends PacketImpl {
    private List<Xid> xids;

    public SessionXAGetInDoubtXidsResponseMessage(List<Xid> xids) {
        super((byte)62);
        this.xids = xids;
    }

    public SessionXAGetInDoubtXidsResponseMessage() {
        super((byte)62);
    }

    @Override
    public boolean isResponse() {
        return true;
    }

    public List<Xid> getXids() {
        return this.xids;
    }

    @Override
    public void encodeRest(ActiveMQBuffer buffer) {
        buffer.writeInt(this.xids.size());
        for (Xid xid : this.xids) {
            XidCodecSupport.encodeXid(xid, buffer);
        }
    }

    @Override
    public void decodeRest(ActiveMQBuffer buffer) {
        int len = buffer.readInt();
        this.xids = new ArrayList<Xid>(len);
        for (int i = 0; i < len; ++i) {
            Xid xid = XidCodecSupport.decodeXid(buffer);
            this.xids.add(xid);
        }
    }

    @Override
    protected String getPacketString() {
        StringBuilder sb = new StringBuilder(super.getPacketString());
        sb.append(", xids=" + String.valueOf(this.xids));
        sb.append("]");
        return sb.toString();
    }

    @Override
    public int hashCode() {
        return super.hashCode() + Objects.hashCode(this.xids);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof SessionXAGetInDoubtXidsResponseMessage)) {
            return false;
        }
        SessionXAGetInDoubtXidsResponseMessage other = (SessionXAGetInDoubtXidsResponseMessage)obj;
        return Objects.equals(this.xids, other.xids);
    }
}

