/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.config.federation;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.core.config.federation.FederationPolicy;
import org.apache.activemq.artemis.utils.Preconditions;

public class FederationPolicySet
implements FederationPolicy<FederationPolicySet>,
Serializable {
    private String name;
    private Set<String> policyRefs = new HashSet<String>();

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public FederationPolicySet setName(String name) {
        this.name = name;
        return this;
    }

    public Set<String> getPolicyRefs() {
        return this.policyRefs;
    }

    public FederationPolicySet addPolicyRef(String name) {
        this.policyRefs.add(name);
        return this;
    }

    public FederationPolicySet setPolicyRefs(Set<String> refs) {
        for (String ref : refs) {
            this.policyRefs.add(ref);
        }
        return this;
    }

    public FederationPolicySet addPolicyRefs(Collection<String> name) {
        this.policyRefs.addAll(name);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FederationPolicySet)) {
            return false;
        }
        FederationPolicySet that = (FederationPolicySet)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.policyRefs, that.policyRefs);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.policyRefs);
    }

    @Override
    public void encode(ActiveMQBuffer buffer) {
        Preconditions.checkArgument((this.name != null ? 1 : 0) != 0, (Object)"name can not be null");
        buffer.writeString(this.name);
        buffer.writeInt(this.policyRefs == null ? 0 : this.policyRefs.size());
        if (this.policyRefs != null) {
            for (String policyRef : this.policyRefs) {
                buffer.writeString(policyRef);
            }
        }
    }

    @Override
    public void decode(ActiveMQBuffer buffer) {
        this.name = buffer.readString();
        int policyRefsSize = buffer.readInt();
        this.policyRefs = new HashSet<String>();
        for (int i = 0; i < policyRefsSize; ++i) {
            this.policyRefs.add(buffer.readString());
        }
    }
}

