/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.provider.dom4j;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Providers;
import org.apache.cxf.jaxrs.provider.AbstractConfigurableProvider;
import org.apache.cxf.jaxrs.utils.ExceptionUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.staxutils.StaxUtils;
import org.dom4j.Document;
import org.dom4j.io.DOMReader;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

@Produces(value={"application/xml", "application/*+xml", "text/xml", "application/json", "application/*+json"})
@Consumes(value={"application/xml", "application/*+xml", "text/xml", "application/json", "application/*+json"})
public class DOM4JProvider
extends AbstractConfigurableProvider
implements MessageBodyReader<Document>,
MessageBodyWriter<Document> {
    public static final String SUPPRESS_XML_DECLARATION = "suppress.xml.declaration";
    private static final Class<org.w3c.dom.Document> DOM_DOC_CLS = org.w3c.dom.Document.class;
    private Providers providers;
    private boolean convertAlways;

    @Context
    public void setProviders(Providers providers) {
        this.providers = providers;
    }

    public boolean isReadable(Class<?> cls, Type type, Annotation[] anns, MediaType mt) {
        return Document.class.isAssignableFrom(cls);
    }

    public Document readFrom(Class<Document> cls, Type type, Annotation[] anns, MediaType mt, MultivaluedMap<String, String> headers, InputStream is) throws IOException, WebApplicationException {
        MessageBodyReader reader = this.providers.getMessageBodyReader(DOM_DOC_CLS, DOM_DOC_CLS, anns, mt);
        if (reader == null) {
            throw ExceptionUtils.toNotSupportedException(null, null);
        }
        org.w3c.dom.Document domDoc = (org.w3c.dom.Document)reader.readFrom(DOM_DOC_CLS, DOM_DOC_CLS, anns, mt, headers, is);
        return new DOMReader().read(domDoc);
    }

    public long getSize(Document doc, Class<?> cls, Type type, Annotation[] anns, MediaType mt) {
        return -1L;
    }

    public boolean isWriteable(Class<?> cls, Type type, Annotation[] anns, MediaType mt) {
        return Document.class.isAssignableFrom(cls);
    }

    public void writeTo(Document doc, Class<?> cls, Type type, Annotation[] anns, MediaType mt, MultivaluedMap<String, Object> headers, OutputStream os) throws IOException, WebApplicationException {
        if (!this.convertAlways && mt.getSubtype().contains("xml")) {
            XMLWriter writer;
            if (MessageUtils.getContextualBoolean((Message)this.getCurrentMessage(), (String)SUPPRESS_XML_DECLARATION, (boolean)false)) {
                OutputFormat format = new OutputFormat();
                format.setSuppressDeclaration(true);
                writer = new XMLWriter(os, format);
            } else {
                writer = new XMLWriter(os);
            }
            writer.write(doc);
            writer.flush();
        } else {
            org.w3c.dom.Document domDoc = this.convertToDOM(doc);
            MessageBodyWriter writer = this.providers.getMessageBodyWriter(DOM_DOC_CLS, DOM_DOC_CLS, anns, mt);
            if (writer == null) {
                throw ExceptionUtils.toNotAcceptableException(null, null);
            }
            writer.writeTo((Object)domDoc, DOM_DOC_CLS, DOM_DOC_CLS, anns, mt, headers, os);
        }
    }

    protected Message getCurrentMessage() {
        return JAXRSUtils.getCurrentMessage();
    }

    private org.w3c.dom.Document convertToDOM(Document doc) {
        String xml = doc.asXML();
        try {
            return StaxUtils.read((Reader)new StringReader(xml));
        }
        catch (Exception ex) {
            throw ExceptionUtils.toInternalServerErrorException((Throwable)ex, null);
        }
    }

    public void convertToDOMAlways(boolean convert) {
        this.convertAlways = convert;
    }
}

