/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.tools.config;

import java.io.IOException;
import java.net.URL;
import java.util.Iterator;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.velocity.tools.config.Configuration;
import org.apache.velocity.tools.config.Data;
import org.apache.velocity.tools.config.FileFactoryConfiguration;
import org.apache.velocity.tools.config.Property;
import org.apache.velocity.tools.config.ToolConfiguration;
import org.apache.velocity.tools.config.ToolboxConfiguration;
import org.apache.velocity.util.ExtProperties;

public class PropertiesFactoryConfiguration
extends FileFactoryConfiguration {
    public PropertiesFactoryConfiguration() {
        this("");
    }

    public PropertiesFactoryConfiguration(String id) {
        super(PropertiesFactoryConfiguration.class, id);
    }

    @Override
    protected void readImpl(URL url) throws IOException {
        ExtProperties props = new ExtProperties();
        props.load(url.openStream());
        this.read(props.subset("tools"));
    }

    public void read(ExtProperties factory) {
        this.readProperties(factory, this);
        this.readToolboxes(factory);
        this.readData(factory.subset("data"));
    }

    protected void readProperties(ExtProperties configProps, Configuration config) {
        ExtProperties properties = configProps.subset("property");
        if (properties != null) {
            Iterator<String> i = properties.getKeys();
            while (i.hasNext()) {
                String name = i.next();
                String value = properties.getString(name);
                ExtProperties propProps = properties.subset(name);
                if (propProps.size() == 1) {
                    config.setProperty(name, value);
                    continue;
                }
                Property property = new Property();
                property.setName(name);
                property.setValue(value);
                this.setProperties(propProps, property);
            }
        }
    }

    protected void readToolboxes(ExtProperties factory) {
        String[] scopes;
        for (String scope : scopes = factory.getStringArray("toolbox")) {
            ToolboxConfiguration toolbox = new ToolboxConfiguration();
            toolbox.setScope(scope);
            this.addToolbox(toolbox);
            ExtProperties toolboxProps = factory.subset(scope);
            this.readTools(toolboxProps, toolbox);
            this.readProperties(toolboxProps, toolbox);
        }
    }

    protected void readTools(ExtProperties tools, ToolboxConfiguration toolbox) {
        Iterator<String> i = tools.getKeys();
        while (i.hasNext()) {
            String key = i.next();
            if (key.indexOf(46) >= 0) continue;
            String classname = tools.getString(key);
            ToolConfiguration tool = new ToolConfiguration();
            tool.setClassname(classname);
            tool.setKey(key);
            toolbox.addTool(tool);
            ExtProperties toolProps = tools.subset(key);
            this.readProperties(toolProps, tool);
            Iterator<String> j = toolProps.getKeys();
            while (j.hasNext()) {
                String name = j.next();
                if (name.equals(tool.getKey())) continue;
                tool.setProperty(name, toolProps.getString(name));
            }
            String restrictTo = toolProps.getString("restrictTo");
            tool.setRestrictTo(restrictTo);
        }
    }

    protected void readData(ExtProperties dataset) {
        if (dataset != null) {
            Iterator<String> i = dataset.getKeys();
            while (i.hasNext()) {
                String key = i.next();
                if (key.indexOf(46) >= 0) continue;
                Data data = new Data();
                data.setKey(key);
                data.setValue(dataset.getString(key));
                ExtProperties props = dataset.subset(key);
                this.setProperties(props, data);
                this.addData(data);
            }
        }
    }

    protected void setProperties(ExtProperties props, Data data) {
        try {
            BeanUtils.populate(data, props);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

