/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.config.exclusion;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.rat.config.exclusion.ExclusionUtils;
import org.apache.rat.config.exclusion.MatcherSet;
import org.apache.rat.config.exclusion.StandardCollection;
import org.apache.rat.document.DocumentName;
import org.apache.rat.document.DocumentNameMatcher;
import org.apache.rat.utils.DefaultLog;
import org.apache.rat.utils.ExtendedIterator;

public class ExclusionProcessor {
    private final Set<String> excludedPatterns = new HashSet<String>();
    private final List<DocumentNameMatcher> excludedPaths = new ArrayList<DocumentNameMatcher>();
    private final Set<String> includedPatterns = new HashSet<String>();
    private final List<DocumentNameMatcher> includedPaths = new ArrayList<DocumentNameMatcher>();
    private final Set<StandardCollection> fileProcessors = new HashSet<StandardCollection>();
    private final Set<StandardCollection> includedCollections = new HashSet<StandardCollection>();
    private final Set<StandardCollection> excludedCollections = new HashSet<StandardCollection>();
    private DocumentNameMatcher lastMatcher;
    private DocumentName lastMatcherBaseDir;

    private void resetLastMatcher() {
        this.lastMatcher = null;
        this.lastMatcherBaseDir = null;
    }

    public ExclusionProcessor addIncludedPatterns(Iterable<String> patterns) {
        DefaultLog.getInstance().info(String.format("Including patterns: %s", String.join((CharSequence)", ", patterns)));
        patterns.forEach(this.includedPatterns::add);
        this.resetLastMatcher();
        return this;
    }

    public ExclusionProcessor addIncludedMatcher(DocumentNameMatcher matcher) {
        if (matcher != null) {
            this.includedPaths.add(matcher);
            this.resetLastMatcher();
        }
        return this;
    }

    public ExclusionProcessor addFileProcessor(StandardCollection collection) {
        if (collection != null) {
            DefaultLog.getInstance().info(String.format("Processing exclude file from %s.", new Object[]{collection}));
            this.fileProcessors.add(collection);
            this.resetLastMatcher();
        }
        return this;
    }

    public ExclusionProcessor addIncludedCollection(StandardCollection collection) {
        if (collection != null) {
            DefaultLog.getInstance().info(String.format("Including %s collection.", new Object[]{collection}));
            this.includedCollections.add(collection);
            this.resetLastMatcher();
        }
        return this;
    }

    public ExclusionProcessor addExcludedPatterns(Iterable<String> patterns) {
        DefaultLog.getInstance().info(String.format("Excluding patterns: %s", String.join((CharSequence)", ", patterns)));
        patterns.forEach(this.excludedPatterns::add);
        this.resetLastMatcher();
        return this;
    }

    public ExclusionProcessor addExcludedMatcher(DocumentNameMatcher matcher) {
        if (matcher != null) {
            this.excludedPaths.add(matcher);
            this.resetLastMatcher();
        }
        return this;
    }

    public ExclusionProcessor addExcludedCollection(StandardCollection collection) {
        if (collection != null) {
            DefaultLog.getInstance().info(String.format("Excluding %s collection.", new Object[]{collection}));
            this.excludedCollections.add(collection);
            this.resetLastMatcher();
        }
        return this;
    }

    public DocumentNameMatcher getNameMatcher(DocumentName basedir) {
        if (this.lastMatcher == null || !basedir.equals(this.lastMatcherBaseDir)) {
            this.lastMatcherBaseDir = basedir;
            List<MatcherSet> matchers = this.extractFileProcessors(basedir);
            MatcherSet.Builder fromCommandLine = new MatcherSet.Builder();
            DocumentName.Builder nameBuilder = DocumentName.builder(basedir).setBaseName(basedir);
            this.extractPatterns(nameBuilder, fromCommandLine);
            this.extractCollectionPatterns(nameBuilder, fromCommandLine);
            this.extractCollectionMatchers(fromCommandLine);
            this.extractPaths(fromCommandLine);
            matchers.add(fromCommandLine.build());
            this.lastMatcher = MatcherSet.merge(matchers).createMatcher();
            DefaultLog.getInstance().debug(String.format("Created matcher set for %s%n%s", basedir.getName(), this.lastMatcher));
        }
        return this.lastMatcher;
    }

    private List<MatcherSet> extractFileProcessors(DocumentName basedir) {
        ArrayList<MatcherSet> fileProcessorList = new ArrayList<MatcherSet>();
        for (StandardCollection sc : this.fileProcessors) {
            ExtendedIterator<List> iter = sc.fileProcessorBuilder().map(builder -> builder.build(basedir));
            if (iter.hasNext()) {
                iter.forEachRemaining(fileProcessorList::addAll);
                continue;
            }
            DefaultLog.getInstance().debug(String.format("%s does not have a fileProcessor.", new Object[]{sc}));
        }
        return fileProcessorList;
    }

    private String preparePattern(DocumentName documentName, String pattern) {
        return ExclusionUtils.qualifyPattern(documentName, ExclusionUtils.convertSeparator(pattern, "/", documentName.getDirectorySeparator()));
    }

    private void extractPatterns(DocumentName.Builder nameBuilder, MatcherSet.Builder matcherBuilder) {
        DocumentName name = nameBuilder.setName("Patterns").build();
        if (!this.excludedPatterns.isEmpty()) {
            matcherBuilder.addExcluded(name, this.excludedPatterns.stream().map(s -> this.preparePattern(name, (String)s)).collect(Collectors.toSet()));
        }
        if (!this.includedPatterns.isEmpty()) {
            matcherBuilder.addIncluded(name, this.includedPatterns.stream().map(s -> this.preparePattern(name, (String)s)).collect(Collectors.toSet()));
        }
    }

    private void extractCollectionPatterns(DocumentName.Builder nameBuilder, MatcherSet.Builder matcherBuilder) {
        Set<String> patterns;
        TreeSet<String> incl = new TreeSet<String>();
        TreeSet<String> excl = new TreeSet<String>();
        for (StandardCollection sc : this.includedCollections) {
            patterns = sc.patterns();
            if (patterns.isEmpty()) {
                DefaultLog.getInstance().debug(String.format("%s does not have a defined collection for inclusion.", new Object[]{sc}));
                continue;
            }
            MatcherSet.Builder.segregateList(incl, excl, sc.patterns());
        }
        for (StandardCollection sc : this.excludedCollections) {
            patterns = sc.patterns();
            if (patterns.isEmpty()) {
                DefaultLog.getInstance().debug(String.format("%s does not have a defined collection for exclusion.", new Object[]{sc}));
                continue;
            }
            MatcherSet.Builder.segregateList(excl, incl, sc.patterns());
        }
        DocumentName name = nameBuilder.setName("Collections").build();
        matcherBuilder.addExcluded(name, excl.stream().map(s -> this.preparePattern(name.getBaseDocumentName(), (String)s)).collect(Collectors.toSet())).addIncluded(name, incl.stream().map(s -> this.preparePattern(name.getBaseDocumentName(), (String)s)).collect(Collectors.toSet()));
    }

    private void extractCollectionMatchers(MatcherSet.Builder matcherBuilder) {
        ExtendedIterator.create(this.includedCollections.iterator()).map(StandardCollection::staticDocumentNameMatcher).filter(Objects::nonNull).forEachRemaining(matcherBuilder::addIncluded);
        ExtendedIterator.create(this.excludedCollections.iterator()).map(StandardCollection::staticDocumentNameMatcher).filter(Objects::nonNull).forEachRemaining(matcherBuilder::addExcluded);
    }

    private void extractPaths(MatcherSet.Builder matcherBuilder) {
        if (!this.includedPaths.isEmpty()) {
            for (DocumentNameMatcher matcher : this.includedPaths) {
                DefaultLog.getInstance().info(String.format("Including path matcher %s", matcher));
                matcherBuilder.addIncluded(matcher);
            }
        }
        if (!this.excludedPaths.isEmpty()) {
            for (DocumentNameMatcher matcher : this.excludedPaths) {
                DefaultLog.getInstance().info(String.format("Excluding path matcher %s", matcher));
                matcherBuilder.addExcluded(matcher);
            }
        }
    }
}

