/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.api;

import java.nio.charset.Charset;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.rat.api.Document;
import org.apache.rat.license.ILicense;
import org.apache.rat.utils.DefaultLog;
import org.apache.tika.mime.MediaType;

public class MetaData {
    private final SortedSet<ILicense> matchedLicenses = new TreeSet<ILicense>();
    private Predicate<ILicense> approvalPredicate;
    private Charset charset;
    private MediaType mediaType;
    private Document.Type documentType;
    private boolean isDirectory;

    public Charset getCharset() {
        return this.charset == null ? Charset.defaultCharset() : this.charset;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public boolean hasCharset() {
        return this.charset != null;
    }

    public MediaType getMediaType() {
        return this.mediaType;
    }

    public void setMediaType(MediaType mediaType) {
        this.mediaType = mediaType;
    }

    public boolean detectedLicense() {
        return !this.matchedLicenses.isEmpty();
    }

    private Predicate<ILicense> getApprovalPredicate() {
        if (this.approvalPredicate == null) {
            DefaultLog.getInstance().error("Approval predicate was not set.");
            throw new IllegalStateException("Approval predicate was not set.");
        }
        return this.approvalPredicate;
    }

    public void setApprovalPredicate(Predicate<ILicense> approvalPredicate) {
        this.approvalPredicate = approvalPredicate;
    }

    public Stream<ILicense> licenses() {
        return this.matchedLicenses.stream();
    }

    public Stream<ILicense> approvedLicenses() {
        return this.licenses().filter(this::isApproved);
    }

    public boolean isApproved(ILicense license) {
        return this.getApprovalPredicate().test(license);
    }

    public Stream<ILicense> unapprovedLicenses() {
        return this.licenses().filter(lic -> !this.isApproved((ILicense)lic));
    }

    public void setDocumentType(Document.Type type) {
        this.documentType = type;
    }

    public void setIsDirectory(boolean state) {
        this.isDirectory = state;
    }

    public boolean isDirectory() {
        return this.isDirectory;
    }

    public Document.Type getDocumentType() {
        return this.documentType;
    }

    public void reportOnLicense(ILicense license) {
        this.matchedLicenses.add(license);
    }

    public void removeLicenses(Predicate<ILicense> filter) {
        this.matchedLicenses.removeIf(filter);
    }

    public String toString() {
        return String.format("MetaData[%s license, %s approved]", this.matchedLicenses.size(), this.approvalPredicate == null ? "unknown" : Long.valueOf(this.matchedLicenses.stream().filter(this.getApprovalPredicate()).count()));
    }
}

