/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.statistics.distribution;

import java.util.function.DoubleBinaryOperator;
import java.util.function.DoubleUnaryOperator;
import org.apache.commons.numbers.rootfinder.BrentSolver;
import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.distribution.InverseTransformContinuousSampler;
import org.apache.commons.rng.sampling.distribution.SharedStateContinuousSampler;
import org.apache.commons.statistics.distribution.ArgumentUtils;
import org.apache.commons.statistics.distribution.ContinuousDistribution;
import org.apache.commons.statistics.distribution.DistributionException;

abstract class AbstractContinuousDistribution
implements ContinuousDistribution {
    private static final double SOLVER_RELATIVE_ACCURACY = (double)1.110223E-16f;
    private static final double SOLVER_ABSOLUTE_ACCURACY = Double.MIN_VALUE;
    private static final double SOLVER_FUNCTION_VALUE_ACCURACY = Double.MIN_VALUE;
    private double median = Double.NaN;

    AbstractContinuousDistribution() {
    }

    double getMedian() {
        double m = this.median;
        if (Double.isNaN(m)) {
            this.median = m = this.inverseCumulativeProbability(0.5);
        }
        return m;
    }

    @Override
    public double probability(double x0, double x1) {
        if (x0 > x1) {
            throw new DistributionException("Lower bound %s > upper bound %s", x0, x1);
        }
        double m = this.getMedian();
        if (x0 >= m) {
            return this.survivalProbability(x0) - this.survivalProbability(x1);
        }
        return this.cumulativeProbability(x1) - this.cumulativeProbability(x0);
    }

    @Override
    public double inverseCumulativeProbability(double p) {
        ArgumentUtils.checkProbability(p);
        return this.inverseProbability(p, 1.0 - p, false);
    }

    @Override
    public double inverseSurvivalProbability(double p) {
        ArgumentUtils.checkProbability(p);
        return this.inverseProbability(1.0 - p, p, true);
    }

    private double inverseProbability(double p, double q, boolean complement) {
        boolean chebyshevApplies;
        double lowerBound = this.getSupportLowerBound();
        if (p == 0.0) {
            return lowerBound;
        }
        double upperBound = this.getSupportUpperBound();
        if (q == 0.0) {
            return upperBound;
        }
        double mu = this.getMean();
        double sig = Math.sqrt(this.getVariance());
        boolean bl = chebyshevApplies = Double.isFinite(mu) && ArgumentUtils.isFiniteStrictlyPositive(sig);
        if (lowerBound == Double.NEGATIVE_INFINITY) {
            lowerBound = this.createFiniteLowerBound(p, q, complement, upperBound, mu, sig, chebyshevApplies);
        }
        if (upperBound == Double.POSITIVE_INFINITY) {
            upperBound = this.createFiniteUpperBound(p, q, complement, lowerBound, mu, sig, chebyshevApplies);
        }
        if (upperBound == Double.MAX_VALUE && (complement ? this.survivalProbability(upperBound) > q : this.cumulativeProbability(upperBound) < p)) {
            return this.getSupportUpperBound();
        }
        if (lowerBound == -1.7976931348623157E308 && (complement ? this.survivalProbability(lowerBound) < q : this.cumulativeProbability(lowerBound) > p)) {
            return this.getSupportLowerBound();
        }
        DoubleUnaryOperator fun = complement ? arg -> this.survivalProbability(arg) - q : arg -> this.cumulativeProbability(arg) - p;
        double x = new BrentSolver((double)1.110223E-16f, Double.MIN_VALUE, Double.MIN_VALUE).findRoot(fun, lowerBound, lowerBound + 0.5 * (upperBound - lowerBound), upperBound);
        if (!this.isSupportConnected()) {
            return this.searchPlateau(complement, lowerBound, x);
        }
        return x;
    }

    private double createFiniteLowerBound(double p, double q, boolean complement, double upperBound, double mu, double sig, boolean chebyshevApplies) {
        double lowerBound = chebyshevApplies ? mu - sig * Math.sqrt(q / p) : Double.NEGATIVE_INFINITY;
        if (lowerBound == Double.NEGATIVE_INFINITY) {
            lowerBound = Math.min(-1.0, upperBound);
            if (complement) {
                while (this.survivalProbability(lowerBound) < q) {
                    lowerBound *= 2.0;
                }
            } else {
                while (this.cumulativeProbability(lowerBound) >= p) {
                    lowerBound *= 2.0;
                }
            }
            lowerBound = Math.max(lowerBound, -1.7976931348623157E308);
        }
        return lowerBound;
    }

    private double createFiniteUpperBound(double p, double q, boolean complement, double lowerBound, double mu, double sig, boolean chebyshevApplies) {
        double upperBound = chebyshevApplies ? mu + sig * Math.sqrt(p / q) : Double.POSITIVE_INFINITY;
        if (upperBound == Double.POSITIVE_INFINITY) {
            upperBound = Math.max(1.0, lowerBound);
            if (complement) {
                while (this.survivalProbability(upperBound) >= q) {
                    upperBound *= 2.0;
                }
            } else {
                while (this.cumulativeProbability(upperBound) < p) {
                    upperBound *= 2.0;
                }
            }
            upperBound = Math.min(upperBound, Double.MAX_VALUE);
        }
        return upperBound;
    }

    boolean isSupportConnected() {
        return true;
    }

    private double searchPlateau(boolean complement, double lower, double x) {
        double dx = Math.max(Double.MIN_VALUE, Math.ulp(x));
        if (x - dx >= lower) {
            DoubleUnaryOperator fun = complement ? this::survivalProbability : this::cumulativeProbability;
            double px = fun.applyAsDouble(x);
            if (fun.applyAsDouble(x - dx) == px) {
                DoubleBinaryOperator cmp;
                double upperBound = x;
                double lowerBound = lower;
                DoubleBinaryOperator doubleBinaryOperator = cmp = complement ? (a, b) -> a > b ? -1.0 : 1.0 : (a, b) -> a < b ? -1.0 : 1.0;
                while (upperBound - lowerBound > dx) {
                    double midPoint = 0.5 * (lowerBound + upperBound);
                    if (cmp.applyAsDouble(fun.applyAsDouble(midPoint), px) < 0.0) {
                        lowerBound = midPoint;
                        continue;
                    }
                    upperBound = midPoint;
                }
                return upperBound;
            }
        }
        return x;
    }

    @Override
    public ContinuousDistribution.Sampler createSampler(UniformRandomProvider rng) {
        return () -> ((SharedStateContinuousSampler)InverseTransformContinuousSampler.of((UniformRandomProvider)rng, this::inverseCumulativeProbability)).sample();
    }
}

